% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_betw_arrays.R
\name{dist_betw_arrays}
\alias{dist_betw_arrays}
\title{Distance between rows of two arrays}
\usage{
dist_betw_arrays(x, y, distance = c("rmsd", "mad", "propdiff"), cores = 1)
}
\arguments{
\item{x}{A numeric array.}

\item{y}{A second numeric array, with the same dimensions as \code{x}.}

\item{distance}{Indicates whether to use Euclidean distance
(\code{"rmsd"} for root mean square difference), the mean absolute
difference (\code{"mad"}), or the proportion of differences (\code{"propdiff"}).}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
If \code{x} and \code{y} have \code{m} and \code{n} rows, respectively, the
result is an \code{m} by \code{n} matrix whose (i,j)th element is the
distance between the ith row of \code{x} and the jth row of
\code{y}.
}
\description{
Calculate the distances between the rows of two multi-dimensional
arrays.
}
\details{
The two arrays need to have the same dimensions, except for the
leading dimension (rows). They are turned into matrices by merging
all but the leading dimension, and then they're sent to
\code{\link[=dist_betw_matrices]{dist_betw_matrices()}}.
}
\examples{
p <- 10
k <- 6
n <- 5
m <- 3
x <- array(stats::rnorm(n*k*p), dim=c(n,k,p))
rownames(x) <- LETTERS[1:n]
y <- array(stats::rnorm(m*k*p), dim=c(m,k,p))
rownames(y) <- letters[1:m]

d <- dist_betw_arrays(x, y)

}
\seealso{
\code{\link[=dist_betw_matrices]{dist_betw_matrices()}}, \code{\link[=corr_betw_matrices]{corr_betw_matrices()}}
}
