% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{updated_model}
\alias{updated_model}
\title{Constructs a new model with noised residuals:
y_new  = y_fitted + residuals*noise}
\usage{
updated_model(model, fitting_data, distribution = "rnorm")
}
\arguments{
\item{model}{An existing fit from a model function such as `lm`, `lfe`, `Arima` and others
compatible with `update`.}

\item{fitting_data}{Data used to adjust a linear model.}

\item{distribution}{Type of noise added to residuals, ej "rnorm" or "rrademacher".}
}
\value{
Constructed linear model.
}
\description{
Constructs a new model with noised residuals:
y_new  = y_fitted + residuals*noise
}
\examples{
x <- 1:100
y <- 2*x + rnorm(100)
model <- lm(y~x-1)
fitting_data <- model.frame(model)
updated_model(model, fitting_data)
updated_model(model, fitting_data, distribution = "rnorm")
updated_model(model, fitting_data, distribution = "rmammen_point")
updated_model(model, fitting_data, distribution = "rmammen_cont")
updated_model(model, fitting_data, distribution = "rrademacher")

x_arma <- rnorm(100)
arma_model <- forecast::Arima(x_arma, c(1, 0, 1))
fitting_data_arma <- model.frame(arma_model)
updated_model(arma_model, fitting_data_arma)
}
