% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altercandles.R
\name{altercandles}
\alias{altercandles}
\title{Get Alternative Candlestick Data}
\usage{
altercandles(symbol = "BRX", from = "2023-11-27", to = Sys.Date())
}
\arguments{
\item{symbol}{Stock symbol to fetch candlestick data for.}

\item{from}{Starting date for the candlestick data in 'YYYY-MM-DD' format.}

\item{to}{Ending date for the candlestick data in 'YYYY-MM-DD' format.}
}
\value{
A data frame containing the candlestick data if the request was successful, NULL otherwise.
}
\description{
Retrieves alternative candlestick data for a given stock symbol
within the specified date range. The API token is retrieved from
an environment variable 'LIMEX_API_TOKEN'.
}
\examples{
\dontrun{
  candles_data <- altercandles(symbol = "BRX", from = "2023-07-31", to = "2023-08-24")
}
}
