% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binomial.R
\name{likbinom}
\alias{likbinom}
\title{Binomial Log Likelihood Function}
\usage{
likbinom(x, size, prob, log = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric scalar for the log likelihood of the binomial density given
the data where size and prob can be held constant or if vector were given
vector will be returned.
}
\description{
The log likelihood of a binomial density with data, x, size and prob
parameters.
}
\details{
The log likelihood is the log of a function of parameters given the data.
}
\examples{
likbinom(x = rbinom(n = 2, size = 3, prob = .4),
        size = 3, prob = .4)
}
