# WARNING - Generated by {fusen} from dev/flat_split_combine.Rmd: do not edit by hand

#' Combine a parsed tbl Rmd / Qmd file into a new file
#' @param parsed_tbl A tibble with columns as issued by `split_to_tbl()`
#' @param output_file A Rmd / Qmd file path to write the new content
#' @return The content of a Rmd / Qmd file as character and
#' the resulting file if output_file is provided.
#' @export
#' @examples
#' file <- system.file("dev-template-parsing.Rmd",
#'   package = "lightparser"
#' )
#' # split first
#' tbl_rmd <- split_to_tbl(file)
#' # apply your filters
#' tbl_rmd_filtered <- tbl_rmd[-5, ]
#' # combine then
#' combine_tbl_to_file(tbl_rmd_filtered, tempfile(fileext = ".Rmd"))
combine_tbl_to_file <- function(parsed_tbl, output_file) {
  # check that parsed_tbl is a tibble with the proper 6 columns
  if (!inherits(parsed_tbl, "tbl_df")) {
    stop("parsed_tbl must be a tibble")
  }
  if (!all(c("type", "label", "params", "text", "code", "heading") %in%
    colnames(parsed_tbl))) {
    stop(
      "parsed_tbl must have 6 columns:",
      " type, label, params, text, code, heading"
    )
  }

  parsed_tbl_content <- get_content_parsedtbl(parsed_tbl)
  full_content <- paste0(parsed_tbl_content$content, collapse = "\n")

  if (!missing(output_file)) {
    writeLines(enc2utf8(full_content), con = output_file)
    return(invisible(full_content))
  } else {
    return(full_content)
  }
}

#' Prepare all content from parsedtbl to be combined into a Rmd file
#' @param parsed_tbl A tibble with 8 columns as issued by `split_to_tbl()`
#' @return A tibble with a new column `content` containing the content
#'  for the future rmd file
#' @noRd
get_content_parsedtbl <- function(parsed_tbl) {
  parsed_tbl$content <-
    apply(
      parsed_tbl, 1,
      function(x) create_content(x$type, x$params, x$code, x$text)
    )

  return(parsed_tbl)
}

#' Create YAML content from list of params
#' @param params A list of YAML parameters
#' @return A character string of YAML content
#' @noRd
create_content_yaml <- function(params) {
  paste0("---\n", yaml::as.yaml(params), "---\n")
}

#' Create R code chunk content
#' @param params A list of chunk parameters
#' @param code A character string of R code
#' @return A character string of R code chunk content
#' @noRd
create_content_r_chunk <- function(params, code) {
  other_params <- params[which(names(params) != "label")]

  paste0(
    # USe \\u0060 instead of "`"
    # so that Vscode does not interpret it as chunk
    "\u0060``{r",
    ifelse(
      is.null(params$label) || grepl("unnamed-chunk", params$label),
      "",
      paste("", params$label)
    ),
    "}\n",
    ifelse(
      length(other_params) == 0,
      "",
      paste0(
        "#| ",
        gsub(
          "#\\| $", "",
          gsub(
            "\n", "\n#| ",
            yaml::as.yaml(other_params)
          )
        ),
        "\n"
      )
    ),
    paste(code, collapse = "\n"),
    "\n\u0060``\n"
  )
}

#' Create inline or heading content
#' @param text A character vector of inline or heading text
#' @return A character string of inline content
#' @noRd
create_content_inline_or_heading <- function(text) {
  paste(unlist(text), collapse = "\n")
}

#' Create content as character vector based on type
#' @param type A character string indicating the type of content
#' @param params A list of parameters
#' @param code A character string of code
#' @param text A character vector of text
#' @return A character string of content
#' @noRd
create_content <- function(type, params, code, text) {
  switch(type,
    "yaml" = create_content_yaml(params),
    "block" = create_content_r_chunk(params, code),
    "inline" = create_content_inline_or_heading(text),
    "heading" = create_content_inline_or_heading(text),
    NA_character_
  )
}
