% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_match.R
\name{height_regression}
\alias{height_regression}
\title{Regression of detected heights VS reference heights}
\usage{
height_regression(lr, ld, matched, plot = TRUE, species = NULL, ...)
}
\arguments{
\item{lr}{data.frame or matrix. 3D coordinates (X Y Height) of reference 
positions}

\item{ld}{data.frame or matrix. 3D coordinates (X Y Height) of detected 
positions}

\item{matched}{data.frame. contains pair indices, typically returned by \code{\link{tree_matching}}}

\item{plot}{boolean. indicates whether results should be plotted}

\item{species}{vector of strings. species for standardized color use by call 
to \code{\link{species_color}}}

\item{...}{arguments to be passed to methods, as in \code{\link[graphics]{plot}}}
}
\value{
A list with two elements. First one is the linear regression model, 
second one is a list with stats (root mean square error, bias and standard 
deviation of detected heights compared to reference heights).
}
\description{
Computes a linear regression model between the reference heights and the 
detected heights of matched pairs.
}
\examples{
# create tree locations and heights
ref_trees <- cbind(c(1, 4, 3, 4, 2), c(1, 1, 2, 3, 4), c(15, 18, 20, 10, 11))
def_trees <- cbind(c(2, 2, 4, 4), c(1, 3, 4, 1), c(16, 19, 9, 15))

# tree matching
match1 <- tree_matching(ref_trees, def_trees)

# height regression
reg <- height_regression(ref_trees, def_trees, match1,
  species = c("ABAL", "ABAL", "FASY", "FASY", "ABAL"),
  asp = 1, xlim = c(0, 21), ylim = c(0, 21)
)
summary(reg$lm)
reg$stats
}
\seealso{
\code{\link{tree_matching}}
}
