% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_growth_post_prob.R
\name{get_growth_post_prob}
\alias{get_growth_post_prob}
\title{Posterior probability of sex being female based on growth}
\source{
Minto, C., Hinde, J. and Coelho, R. (2017). Including unsexed individuals in sex-specific growth models.
\emph{Canadian Journal of Fisheries and Aquatic Sciences}. DOI: 10.1139/cjfas-2016-0450.
}
\usage{
get_growth_post_prob(mixprop, muF, muM, sigmaF, sigmaM, data, distribution)
}
\arguments{
\item{mixprop}{Numeric scalar of mixing proportion (overall sex ratio)}

\item{muF}{Numeric vector with predicted female lengths}

\item{muM}{Numeric vector with predicted male lengths}

\item{sigmaF}{Numeric scalar for female residual standard deviation}

\item{sigmaM}{Numeric scalar for male residual standard deviation}

\item{data}{A data.frame with column "length". Note predicted means "muF" and "muM" must come from corresponding ages.}

\item{distribution}{Character with options: "normal" or "lognormal".}
}
\value{
Numeric vector of the posterior probability of being female.
}
\description{
\code{get_growth_post_prob} returns the probability of
the observation(s) arising from the female component given a set of growth parameters
and an assumed distribution (normal or lognormal). The component probability is
given by Bayes' theorem. Used internally.
}
\examples{
get_growth_post_prob(mixprop = 0.5, muF = 4, muM = 6, sigmaF = 1,
                          sigmaM = 1, data = data.frame(length = 4.5), distribution = "normal")
}
