% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{tune_Lambda}
\alias{tune_Lambda}
\title{Tune Smoothing and Ridge Penalties via Generalized Cross Validation}
\usage{
tune_Lambda(
  y,
  X,
  X_gram,
  smoothing_spline_penalty,
  A,
  K,
  nc,
  nr,
  opt,
  use_custom_bfgs,
  C,
  colnm_expansions,
  wiggle_penalty,
  flat_ridge_penalty,
  invsoftplus_initial_wiggle,
  invsoftplus_initial_flat,
  unique_penalty_per_predictor,
  unique_penalty_per_partition,
  invsoftplus_penalty_vec,
  meta_penalty,
  family,
  unconstrained_fit_fxn,
  keep_weighted_Lambda,
  iterate,
  qp_score_function,
  quadprog,
  qp_Amat,
  qp_bvec,
  qp_meq,
  tol,
  sd_y,
  delta,
  constraint_value_vectors,
  parallel,
  parallel_eigen,
  parallel_trace,
  parallel_aga,
  parallel_matmult,
  parallel_unconstrained,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks,
  shared_env,
  custom_penalty_mat,
  order_list,
  glm_weight_function,
  shur_correction_function,
  need_dispersion_for_estimation,
  dispersion_function,
  observation_weights,
  homogenous_weights,
  blockfit,
  just_linear_without_interactions,
  Vhalf,
  VhalfInv,
  verbose,
  include_warnings,
  ...
)
}
\arguments{
\item{y}{List; response vectors by partition}

\item{X}{List; design matrices by partition}

\item{X_gram}{List; Gram matrices by partition}

\item{smoothing_spline_penalty}{Matrix; integrated squared second derivative penalty}

\item{A}{Matrix; smoothness constraints at knots}

\item{K}{Integer; number of interior knots in 1-D, number of partitions - 1 in higher dimensions}

\item{nc}{Integer; columns per partition}

\item{nr}{Integer; total sample size}

\item{opt}{Logical; TRUE to optimize penalties, FALSE to use initial values}

\item{use_custom_bfgs}{Logical; TRUE for analytic gradient BFGS as natively implemented, FALSE for finite differences as implemented by \code{stats::optim()}.}

\item{wiggle_penalty, flat_ridge_penalty}{Initial penalty values}

\item{invsoftplus_initial_wiggle, invsoftplus_initial_flat}{Initial grid search values (log scale)}

\item{unique_penalty_per_predictor, unique_penalty_per_partition}{Logical; allow predictor/partition-specific penalties}

\item{invsoftplus_penalty_vec}{Initial values for predictor/partition penalties (log scale)}

\item{meta_penalty}{The "meta" ridge penalty, a regularization for predictor/partition penalties to pull them on log-scale towards 0 (1 on raw scale)}

\item{family}{GLM family with optional custom tuning loss}

\item{keep_weighted_Lambda, iterate}{Logical controlling GLM fitting}

\item{qp_score_function, quadprog, qp_Amat, qp_bvec, qp_meq}{Quadratic programming parameters (see arguments of \code{\link[lgspline]{lgspline}})}

\item{tol}{Numeric; convergence tolerance}

\item{sd_y, delta}{Response standardization parameters}

\item{constraint_value_vectors}{List; constraint values}

\item{parallel}{Logical; enable parallel computation}

\item{cl, chunk_size, num_chunks, rem_chunks}{Parallel computation parameters}

\item{custom_penalty_mat}{Optional custom penalty matrix}

\item{order_list}{List; observation ordering by partition}

\item{glm_weight_function, shur_correction_function}{Functions for GLM weights and corrections}

\item{need_dispersion_for_estimation, dispersion_function}{Control dispersion estimation}

\item{observation_weights}{Optional observation weights}

\item{homogenous_weights}{Logical; TRUE if all weights equal}

\item{blockfit}{Logical; when TRUE, block-fitting (not per-partition fitting) approach is used, analogous to quadratic programming.}

\item{just_linear_without_interactions}{Numeric; vector of columns of input predictor matrix that correspond to non-spline effects without interactions, used for block-fitting.}

\item{Vhalf, VhalfInv, }{Square root and inverse square root correlation structures for fitting GEEs.}

\item{verbose}{Logical; print progress}

\item{include_warnings}{Logical; print warnings/try-errors}

\item{...}{Additional arguments passed to fitting functions}
}
\value{
List containing:
\itemize{
  \item Lambda - Final combined penalty matrix
  \item flat_ridge_penalty - Optimized ridge penalty
  \item wiggle_penalty - Optimized smoothing penalty
  \item other_penalties - Optimized predictor/partition penalties
  \item L_predictor_list - Predictor-specific penalty matrices
  \item L_partition_list - Partition-specific penalty matrices
}
}
\description{
Optimizes smoothing spline and ridge regression penalties by minimizing GCV criterion.
Uses BFGS optimization with analytical gradients or finite differences.
}
\details{
Uses BFGS optimization to minimize GCV criterion for penalty selection.
Supports analytical gradients for efficiency with standard GLM families.
Can optimize unique penalties per predictor/partition.
Handles custom loss functions and GLM weights.
Parallel computation available for large problems.
}
\seealso{
\itemize{
  \item \code{\link[stats]{optim}} for Hessian-free optimization
}
}
\keyword{internal}
