% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{make_partitions}
\alias{make_partitions}
\title{Create Data Partitions Using Clustering}
\usage{
make_partitions(
  data,
  cluster_args,
  cluster_on_indicators,
  K,
  parallel,
  cl,
  do_not_cluster_on_these,
  neighbor_tolerance
)
}
\arguments{
\item{data}{Numeric matrix of predictor variables}

\item{cluster_args}{Parameters for clustering}

\item{cluster_on_indicators}{Logical to include binary predictors}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{parallel}{Logical to enable parallel processing}

\item{cl}{Cluster object for parallel computation}

\item{do_not_cluster_on_these}{Columns to exclude from clustering}

\item{neighbor_tolerance}{Scaling factor for neighbor detection}
}
\value{
A list containing:
- centers: Cluster center coordinates
- knots: Knot points between centers
- assign_partition: Function to assign new data to partitions
- neighbors: List of neighboring partition indices
}
\description{
Partitions data support into clusters using Voronoi-like diagrams.
}
\keyword{internal}
