% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgspline.R
\docType{package}
\name{lgspline-package}
\alias{lgspline-package}
\title{Lagrangian Multiplier Smoothing Splines}
\description{
Implements Lagrangian multiplier smoothing splines for flexible nonparametric regression and function estimation. Provides tools for fitting, prediction, and inference using a constrained optimization approach to enforce smoothness. Supports generalized linear models, Weibull accelerated failure time (AFT) models, quadratic programming problems, and customizable arbitrary correlation structures. Options for fitting in parallel are provided. The method builds upon the framework described by Ezhov et al. (2018) \doi{10.1515/jag-2017-0029} using Lagrangian multipliers to fit cubic splines. For more information on correlation structure estimation, see Searle et al. (2009) <ISBN:978-0470009598>. For quadratic programming and constrained optimization in general, see Nocedal & Wright (2006) \doi{10.1007/978-0-387-40065-5}. For a comprehensive background on smoothing splines, see Wahba (1990) \doi{10.1137/1.9781611970128} and Wood (2006) <ISBN:978-1584884743> "Generalized Additive Models: An Introduction with R".
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/matthewlouisdavisBioStat/lgspline}
  \item Report bugs at \url{https://github.com/matthewlouisdavisBioStat/lgspline/issues}
}

}
\author{
\strong{Maintainer}: Matthew Davis \email{matthewlouisdavis@gmail.com} (\href{https://orcid.org/0000-0001-9714-1018}{ORCID})

}
\keyword{constrained}
\keyword{internal}
\keyword{lagrangian}
\keyword{multiplier}
\keyword{parametric}
\keyword{regression}
\keyword{smoothing}
