% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{knot_expand_list}
\alias{knot_expand_list}
\title{Expand Matrix into Partition Lists Based on Knot Boundaries}
\usage{
knot_expand_list(partition_codes, partition_bounds, nr, mat, K)
}
\arguments{
\item{partition_codes}{Numeric vector; values determining partition assignment for each row}

\item{partition_bounds}{Numeric vector; ordered knot locations defining partition boundaries}

\item{nr}{Integer; number of rows in input matrix}

\item{mat}{Numeric matrix; data to be partitioned}

\item{K}{Integer; number of interior knots (resulting in \eqn{K+1} partitions)}
}
\value{
List of length \eqn{K+1}, each element containing the submatrix for that partition
}
\description{
Takes an input \eqn{N \times p} matrix of polynomial expansions and outputs a list of
length \eqn{K+1}, isolating the rows of the input corresponding to assigned partition.
}
\keyword{internal}
