% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fepois.R
\name{fepois}
\alias{fepois}
\title{Fit a Poisson model with multiple group fixed effects}
\usage{
fepois(
  formula,
  data,
  offset = NULL,
  subset = NULL,
  robust = TRUE,
  cluster = NULL,
  pseudo_rsq = FALSE,
  tol = 1e-10
)
}
\arguments{
\item{formula}{an object of class '"formula"' (or one that can be coerced to
that class): a symbolic description of the model to be fitted. Similarly to
'lm'.  See Details.}

\item{data}{a data frame containing the variables of the model.}

\item{offset}{this can be used to specify an \emph{a priori} known component
to be included in the linear predictor during fitting. This should be
\code{NULL} or a numeric vector or matrix of extents matching those of the
response. One or more \code{\link{offset}} terms can be included in the
formula instead or as well, and if more than one are specified their sum is
used. See \code{\link{model.offset}}.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{robust}{logical value to return a robust standard error computation.}

\item{cluster}{optional variable to group by and compute sandwich-type
robust standard errors. Should be a formula of the form \code{~x_j} or
an object that be coerced to a formula.}

\item{pseudo_rsq}{logical value to return a a pseudo-R2 based on Kendall's
correlation.}

\item{tol}{tolerance value for GLM convergence criteria.}
}
\description{
Fit a Poisson model with multiple group fixed effects
}
\seealso{
felm
}
