% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/less-classifier.R
\name{LESSBinaryClassifier}
\alias{LESSBinaryClassifier}
\title{LESSBinaryClassifier}
\value{
R6 class of LESSBinaryClassifier
}
\description{
Auxiliary binary classifier for Learning with Subset Stacking (LESS)
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{\link[less:LESSBase]{less::LESSBase}} -> \code{LESSBinaryClassifier}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LESSBinaryClassifier-new}{\code{LESSBinaryClassifier$new()}}
\item \href{#method-LESSBinaryClassifier-fit}{\code{LESSBinaryClassifier$fit()}}
\item \href{#method-LESSBinaryClassifier-predict_proba}{\code{LESSBinaryClassifier$predict_proba()}}
\item \href{#method-LESSBinaryClassifier-get_global_estimator}{\code{LESSBinaryClassifier$get_global_estimator()}}
\item \href{#method-LESSBinaryClassifier-set_random_state}{\code{LESSBinaryClassifier$set_random_state()}}
\item \href{#method-LESSBinaryClassifier-clone}{\code{LESSBinaryClassifier$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="predict"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-predict'><code>less::SklearnEstimator$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_d_normalize"><a href='../../less/html/LESSBase.html#method-LESSBase-get_d_normalize'><code>less::LESSBase$get_d_normalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_frac"><a href='../../less/html/LESSBase.html#method-LESSBase-get_frac'><code>less::LESSBase$get_frac()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_isFitted"><a href='../../less/html/LESSBase.html#method-LESSBase-get_isFitted'><code>less::LESSBase$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_n_neighbors"><a href='../../less/html/LESSBase.html#method-LESSBase-get_n_neighbors'><code>less::LESSBase$get_n_neighbors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_n_replications"><a href='../../less/html/LESSBase.html#method-LESSBase-get_n_replications'><code>less::LESSBase$get_n_replications()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_n_subsets"><a href='../../less/html/LESSBase.html#method-LESSBase-get_n_subsets'><code>less::LESSBase$get_n_subsets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_random_state"><a href='../../less/html/LESSBase.html#method-LESSBase-get_random_state'><code>less::LESSBase$get_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_replications"><a href='../../less/html/LESSBase.html#method-LESSBase-get_replications'><code>less::LESSBase$get_replications()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_scaling"><a href='../../less/html/LESSBase.html#method-LESSBase-get_scaling'><code>less::LESSBase$get_scaling()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_val_size"><a href='../../less/html/LESSBase.html#method-LESSBase-get_val_size'><code>less::LESSBase$get_val_size()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBinaryClassifier-new"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBinaryClassifier-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of LESSBinaryClassifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBinaryClassifier$new(
  frac = NULL,
  n_neighbors = NULL,
  n_subsets = NULL,
  n_replications = 20,
  d_normalize = TRUE,
  val_size = NULL,
  random_state = NULL,
  tree_method = function(X) KDTree$new(X),
  cluster_method = NULL,
  local_estimator = LinearRegression$new(),
  global_estimator = DecisionTreeClassifier$new(),
  distance_function = NULL,
  scaling = TRUE,
  warnings = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{frac}}{fraction of total samples used for the number of neighbors (default is 0.05)}

\item{\code{n_neighbors}}{number of neighbors (default is NULL)}

\item{\code{n_subsets}}{number of subsets (default is NULL)}

\item{\code{n_replications}}{number of replications (default is 20)}

\item{\code{d_normalize}}{distance normalization (default is TRUE)}

\item{\code{val_size}}{percentage of samples used for validation (default is NULL - no validation)}

\item{\code{random_state}}{initialization of the random seed (default is NULL)}

\item{\code{tree_method}}{method used for constructing the nearest neighbor tree, e.g., less::KDTree (default)}

\item{\code{cluster_method}}{method used for clustering the subsets, e.g., less::KMeans (default is NULL)}

\item{\code{local_estimator}}{estimator for the local models (default is less::LinearRegression)}

\item{\code{global_estimator}}{estimator for the global model (default is less::DecisionTreeRegressor)}

\item{\code{distance_function}}{distance function evaluating the distance from a subset to a sample,
e.g., df(subset, sample) which returns a vector of distances (default is RBF(subset, sample, 1.0/n_subsets^2))}

\item{\code{scaling}}{flag to normalize the input data (default is TRUE)}

\item{\code{warnings}}{flag to turn on (TRUE) or off (FALSE) the warnings (default is TRUE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBinaryClassifier-fit"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBinaryClassifier-fit}{}}}
\subsection{Method \code{fit()}}{
Dummy fit function that calls the proper method according to validation and clustering parameters
Options are:
\itemize{
\item Default fitting (no validation set, no clustering)
\item Fitting with validation set (no clustering)
\item Fitting with clustering (no) validation set)
\item Fitting with validation set and clustering
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBinaryClassifier$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes response variables}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of LESSBinaryClassifier
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBinaryClassifier-predict_proba"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBinaryClassifier-predict_proba}{}}}
\subsection{Method \code{predict_proba()}}{
Prediction probabilities are evaluated for the test samples in X0
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBinaryClassifier$predict_proba(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBinaryClassifier-get_global_estimator"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBinaryClassifier-get_global_estimator}{}}}
\subsection{Method \code{get_global_estimator()}}{
Auxiliary function returning the global_estimator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBinaryClassifier$get_global_estimator()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBinaryClassifier-set_random_state"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBinaryClassifier-set_random_state}{}}}
\subsection{Method \code{set_random_state()}}{
Auxiliary function that sets random state attribute of the self class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBinaryClassifier$set_random_state(random_state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{random_state}}{seed number to be set as random state}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBinaryClassifier-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBinaryClassifier-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBinaryClassifier$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
