% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-lenses.R
\name{map_l}
\alias{map_l}
\title{Promote a lens to apply to each element of a list}
\usage{
map_l(l)
}
\arguments{
\item{l}{the lens to promote}
}
\description{
Create a new lens that views and sets each element
of the list.
}
\details{
Uses \link{lapply} under the hood for \link{view}
and \link{mapply} under the hood for \link{set}. This means
that \link{set} can be given a list of values to set,
one for each element. If the input or update are
lists this lens always returns a list. If the input
and update are vectors this lens will return a vector.
}
\examples{
(ex <- replicate(10, sample(1:5), simplify = FALSE))
view(ex, map_l(index(1)))
set(ex, map_l(index(1)), 11:20)
}
