% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert2.R
\name{insert.leem}
\alias{insert.leem}
\title{Insert measures of position in plot}
\usage{
\method{insert}{leem}(
  x,
  type = "mean",
  lty = 1,
  lcol = "black",
  tcol = lcol,
  acol = lcol,
  parrow = 0.5,
  larrow = 0.6,
  ptext = 0.06,
  side = "right",
  lwd = 2,
  lwdarrow = lwd,
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{type}{Type of measure of position. The default is \code{type = "mean"}. Other options: \code{"median"}, \code{"mode"} or \code{"all"}.}

\item{lty}{Line type. The default is  \code{lty = 1}.}

\item{lcol}{Vertical line color type. The default is \code{lpcol = "black"}. This argument must be the same length as the \code{type} argument.}

\item{tcol}{Text color type. The default is \code{tcol = lcol}.}

\item{acol}{Arrow color type. The default is \code{acol = lcol}.}

\item{parrow}{Text and arrow height. The default is \code{parrow = 0.5}. This argument must be the same length as the \code{type} argument.}

\item{larrow}{Text and arrow length. The default is \code{larrow = 0.6}.}

\item{ptext}{Distance between lines of text. The default is \code{ptext = 0.06}.}

\item{side}{Side to insert the text. The default is \code{side = "right"}. This argument must be the same length as the \code{type} argument.}

\item{lwd}{numeric argument. The vertical line width. The default is  \code{lwd = 2}.}

\item{lwdarrow}{numeric argument. The arrow width. The default is  \code{lwdarrow = lwd}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
No return value. This function adds elements to an existing plot.
}
\description{
Method of insert function
}
\examples{
# Example 1
library(leem)
set.seed(10)
rnorm(36, 100, 50) |>
 new_leem(variable = "continuous") |>
 tabfreq() |>
 hist() |>
 insert(
  lcol = "black",
  tcol = "purple",
  acol = "brown",
  parrow = 0.6,
  larrow = 0.6,
  ptext = 0.4,
  side = "left",
  lwd = 2,
  lwdarrow = 4
 )
}
