% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{boxplot.leem}
\alias{boxplot.leem}
\title{Box plot}
\usage{
\method{boxplot}{leem}(
  x,
  type = "rawdata",
  details = FALSE,
  horizontal = FALSE,
  coef = 1.5,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  col = rgb(0, 175, 239, maxColorValue = 255),
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{type}{character argument. Default is \code{rawdata}. If \code{type = "classes"}, the function returns a boxplot plot for each set of data grouped of classes of \code{x} object.}

\item{details}{Logical argument. Default is \code{FALSE}, otherwise, in addition to the plot, the measurements necessary for the development of the plot will be displayed on the console.}

\item{horizontal}{Logical argument indicating if the boxplots should be horizontal; default \code{FALSE} means vertical boxes.}

\item{coef}{this determines how far the plot whiskers extend out from the box. If \code{coef} is positive, the whiskers extend to the most extreme data point which is no more than \code{coef} times the interquartile range from the box. A value of zero causes the whiskers to extend to the data extremes.}

\item{main}{Title name. Defaults is \code{NULL}.}

\item{xlab}{a label for the \code{x} axis. Defaults is \code{NULL}.}

\item{ylab}{a label for the \code{y} axis. Defaults is \code{NULL}.}

\item{col}{Character vector. Default \code{col = rgb(0, 175, 239, maxColorValue = 255)}.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Produce box-and-whisker plot(s) of leem class object and computes the necessary values for the development of the plot.
}
\examples{
library(leem)
# Example 1
x <- rnorm(30, 100, 2) |>
  new_leem(variable = 2) |>
  tabfreq()
boxplot(x, details = TRUE)
# Example 2
boxplot(x, type = "classes")

}
