% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_values.R
\name{update_values}
\alias{update_values}
\title{update values in a conductanceMatrix}
\usage{
update_values(x, sf, FUN)
}
\arguments{
\item{x}{\code{conductanceMatrix}}

\item{sf}{\code{sf}}

\item{FUN}{\code{function}}
}
\value{
\code{conductanceMatrix}
}
\description{
Apply a function to values in the \code{conductanceMatrix} that coincide with the supplied sf object
}
\details{
An updated conductanceMatrix is produced by assessing which areas of the conductanceMatrix coincide with the supplied sf object. The values within the areas that coincide with the sf object are modified based on the supplied function
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(960745, 4166836)),
crs = terra::crs(r)))

locs <- sf::st_buffer(x = locs, dist = 25000)

slope_cs2 <- update_values(x = slope_cs, sf = locs, 
FUN = function(j) { j * 0.6})

slope_cs3 <- update_values(x = slope_cs, sf = locs, 
FUN = function(j) { j + 10})

slope_cs4 <- update_values(x = slope_cs, sf = locs, 
FUN = function(j) { replace(x = j, values = 0)})
}
\author{
Joseph Lewis
}
