% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAreaPolygons.R
\name{addAreaPolygons}
\alias{addAreaPolygons}
\title{Add Area Polygons to a Map}
\usage{
addAreaPolygons(map, longitude, latitude, coordinate = "WGS-84")
}
\arguments{
\item{map}{The map object to which the polygons will be added.}

\item{longitude}{A vector of longitudes.}

\item{latitude}{A vector of latitudes.}

\item{coordinate}{A string indicating the coordinate system of the input data. Options are "WGS-84", "GCJ-02", "BD-09".}
}
\value{
The updated map object with added polygons.
}
\description{
This function adds a polygon area to a given map using the specified latitude and longitude coordinates.
}
\examples{
library(leaflet)
m <- leaflet() \%>\% addTilesAmap()
m <- addAreaPolygons(m,
  longitude = c(121.0, 122.1, 121.2, 122.15, 121.2),
  latitude =  c(31.1, 31.919, 31.917, 31.15, 31.12), coordinate = "WGS-84"
)
m
}
