% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FHD}
\alias{FHD}
\title{Foliage Height Diversity}
\usage{
FHD(lad_profile, evenness = FALSE, LAD.threshold = -1)
}
\arguments{
\item{lad_profile}{a data.frame including values of relative LAD at height intervals, output of the lad.profile function (use relative = TRUE)}

\item{evenness}{boolean, defines whether FHD should be based on Shannon's diversity or evenness (Hill 1973).
The default FALSE calculates Shannon diversity as the original FHD by MacArthur and MacArthur (1961);
the alternative TRUE was recommended by Valbuena et al. (2012), and it calculates Shannon evenness dividing it by the natural logarithm of the number of number of voxels with LAD values above the threshold.}

\item{LAD.threshold}{numerical (0,1), defines the minimum value of LAD for considering the relative leaf abundance of a voxel in FHD calculation. Defaults to the inverse of the total number of voxels.}
}
\value{
A \code{\link[base:numeric]{numeric}} containing the Foliage Height Diversity calculated from the Leaf Area Density profile
}
\description{
Calculates the foliage height diversity (FHD) metric
from abundances considered as per-voxel relative LAD values, as described in MacArthur and MacArthur (1961).
}
\examples{
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

# Calculate LAD from voxelization
VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2)

# Calculate the LAD profile
lad_profile = lad.profile(VOXELS_LAD, relative = TRUE)

FHD(lad_profile, evenness = FALSE)
FHD(lad_profile, evenness = TRUE)

}
\references{
Hill M. O. (1973) Diversity and evenness: a unifying notation and its consequences. Ecology. 54: 427–432. \doi{10.2307/1934352}

MacArthur R.H., MacArthur J.W. (1961). On bird species diversity. Ecology 42: 594–598. \doi{10.2307/1932254}

Valbuena R., Packalen P., Martín-Fernández S., Maltamo M. (2012) Diversity and equitability ordering profiles applied to the study of forest structure. Forest Ecology and Management 276: 185–195. \doi{10.1016/j.foreco.2012.03.036}
}
