% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCR.R
\name{PCR_reconstruction}
\alias{PCR_reconstruction}
\title{Principal Component Regression Reconstruction}
\usage{
PCR_reconstruction(Qa, pc, start.year, transform = "log")
}
\arguments{
\item{Qa}{Observations: a data.frame of annual streamflow with at least two columns: year and Qa.}

\item{pc}{For a single model: a data.frame, one column for each principal component. For an ensemble reconstruction: a list, each element is a data.frame of principal components.}

\item{start.year}{Starting year of the climate proxies, i.e, the first year of the paleo period. \code{start.year + nrow(pc) - 1} will determine the last year of the study horizon, which must be greater than or equal to the last year in \code{Qa}.}

\item{transform}{Flow transformation, either "log", "boxcox" or "none". Note that if the Box-Cox transform is used, the confidence interval after back-transformation is simply the back-transform of the trained onfidence interval; this is hackish and not entirely accurate.}
}
\value{
A list of reconstruction results, with the following elements:
\subsection{For a single-model reconstruction:}{
\itemize{
\item rec: reconstructed streamflow with 95\% prediction interval; a data.table with four columns: year, Q, Ql (lower bound), and Qu (upper bound).
\item coeffs: the regression coefficients.
\item sigma: the residual standard deviation.
}
}

\subsection{For an ensemble reconstruction:}{
\itemize{
\item rec: the ensemble average reconstruction; a data.table with two columns: year and Q.
\item ensemble: a list of ensemble members, each element is reconstructed from one element of \code{pc} and is itself a list of three elements: Q (a vector of reconstructed flow), coeffs and sigma.
Note that for ensemble reconstruction, \code{ldsr} does not provide uncertainty estimates. It is up to the user to do so, for example, using ensemble spread.
}
}
}
\description{
Reconstruction with principal component linear regression.
}
\examples{
PCR_reconstruction(NPannual, NPpc, start.year = 1200)
}
