% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldMult.R
\name{WaldMult}
\alias{WaldMult}
\title{Multivariate Wald Test}
\usage{
WaldMult(Mod, pos = NULL, contrasts = NULL, name = NULL, value = NULL)
}
\arguments{
\item{Mod}{an object of class \code{hlme}, \code{lcmm}, \code{multlcmm},
\code{Jointlcmm} or \code{mpjlcmm}}

\item{pos}{a vector containing the indices in \code{Mod$best} of the parameters to
test}

\item{contrasts}{a numeric vector of same length as pos.  If NULL (the
default), a simultaneous test of the appropriate parameters is realised.  If
contrasts is specified, the quantity to test is the dot product of pos and
contrasts.}

\item{name}{a character containing the name the user wants to give to the
test. By default, the name's test is the null hypothesis.}

\item{value}{the value(s) to test against. By default, test against 0.}
}
\value{
If contrasts is NULL, the function returns a matrix with 1 row and 2
columns containing the value of the Wald test's statistic and the associated
p-value.

If contrasts is not NULL, the function returns a matrix with 1 row and 4
columns containing the value of the coefficient (dot product of pos and
contrasts), his standard deviation, the value of the Wald test's statistic
and the associated p-value.
}
\description{
This function provides multivariate and univariate Wald tests for
combinations of parameters from \code{hlme}, \code{lcmm}, \code{multlcmm},
\code{Jointlcmm} or \code{mpjlcmm} models.
}
\author{
Cecile Proust-Lima, Lionelle Nkam and Viviane Philipps
}
