% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JLchemix.r
\name{JLchemix}
\alias{JLchemix}
\title{Latent Class Models for Joint Analysis of Disease Prevalence and High-dimensional Semicontinuous Chimical Biomarker Data}
\usage{
JLchemix(
  nsim = 700,
  nburn = 500,
  Yvariable,
  X.f_mat,
  X.m_mat,
  covariate_f_mat,
  covariate_m_mat,
  seed_num = 678443068,
  K = 3,
  alpha.0f = -6,
  alpha.1f = 1,
  alpha.0m = -6,
  alpha.1m = 1,
  beta.0 = -4.5,
  beta.1f = 0.5,
  beta.1m = 0.5,
  beta.2 = 1,
  b.0f = c(-7.254321, -7.010908, -3.880426, -8.118554, -6.759431, -7.230387, -4.878213,
    -5.007503, -6.856297, -4.489543, -8.068346, -5.106003, -6.45287, -4.495532, -5.517385,
    -6.268557, -6.053185, -5.464252, -6.452734, -5.906192, -6.260919, -5.69159, -5.61441,
    -6.143081, -5.047088, -5.301305, -5.913374, -5.756906, -6.054626, -6.87334, -6.849659,
    -7.004676, -5.332403, -7.307853, -5.183989, -6.383119),
  b.0m = c(-5.079509, -7.272471, -6.521358, -6.128509, -5.696533, -6.374789, -5.777319,
    -4.826086, -8.98966, -6.708051, -4.058636, -5.976921, -5.306304, -4.786394, -6.425503,
    -4.867691, -6.091003, -7.162082, -5.652558, -6.368305, -4.130053, -6.062718,
    -6.272025, -6.096108, -7.405642, -4.415025, -7.6361, -5.613704, -6.741973, -5.124894,
    -7.442003, -6.065161, -6.127977, -6.39778, -5.039697, -5.91236),
  b.1f = c(0.06081535, 0.27933553, 1.09567058, 1.3052503, -1.7136343, 3.56305321,
    1.44386159, 1.11045081, 0.91064552, 2.33861095, 1.8940006, 1.73022487, 0.12834589,
    0.9897258, 0.70672882, 1.82998947, 0.67922938, 0.91639977, 1.92834454, 1.01663356,
    0.13329777, 1.94157555, 0.85399484, 1.57496884, 1.4586229, 1.78167318, -0.07774665,
    2.66127628, -0.58454029, 0.77320667, 0.97268288, 0.85628677, 0.75621566, 1.06990346,
    1.14924001, 0.95091695),
  b.1m = c(1.68599796, 0.53185998, 1.14397009, 2.8661986, 4.08110658, 0.37164953,
    1.54640353, 1.27457107, 3.80397148, 0.82511839, 2.99448637, 2.4121241, 1.47281944,
    0.82053754, 2.01676277, -0.99610755, -0.03900866, 1.47895046, 1.15950092, 0.91964213,
    1.1740925, 1.3381932, 1.36568913, 0.55896975, 1.41116326, 3.3092799, 1.51011954,
    0.90399847, 0.40348049, 1.27435217, 1.53464794, 2.73497557, 1.91075938, 0.93572173,
    2.02485773, 3.82461971),
  eta.0f = 2,
  eta.1f = 0.5,
  eta.0m = 2,
  eta.1m = 0.5,
  Sigma.b = diag(4),
  tau2.f = 0.5,
  tau2.m = 0.5,
  lambda.1f = 0.5,
  lambda.2f = 0,
  lambda.3f = 0,
  lambda.4f = 0,
  lambda.5f = 0,
  lambda.1m = 0.5,
  lambda.2m = 0,
  lambda.3m = 0,
  lambda.4m = 0,
  lambda.5m = 0,
  mu.b0 = 0,
  mu.b1f = 0,
  mu.b1m = 0,
  mu.b2 = 0,
  sig2.b0 = 100,
  sig2.b1f = 1,
  sig2.b1m = 1,
  sig2.b2 = 100,
  mu.a0f = 0,
  mu.a1f = 0,
  mu.a0m = 0,
  mu.a1m = 0,
  sig2.a0f = 100,
  sig2.a1f = 100,
  sig2.a0m = 100,
  sig2.a1m = 100,
  mu.e0f = 0,
  mu.e1f = 0,
  mu.e0m = 0,
  mu.e1m = 0,
  sig2.e0f = 100,
  sig2.e1f = 100,
  sig2.e0m = 100,
  sig2.e1m = 100,
  a.tau = 1,
  b.tau = 1,
  mu.lf = rep(0, covariate_num),
  mu.lm = rep(0, covariate_num),
  Sigma.lf = 10 * diag(covariate_num),
  Sigma.lm = 10 * diag(covariate_num),
  s.b0 = 2.4^2,
  s.b1f = 2.4^2,
  s.b1m = 2.4^2,
  s.b2 = 2.4^2,
  var.b0 = 1,
  var.b1f = 1,
  var.b1m = 1,
  var.b2 = 1,
  s.e0f = 2.4^2,
  s.e1f = 2.4^2,
  s.e0m = 2.4^2,
  s.e1m = 2.4^2,
  var.e0f = 1,
  var.e1f = 1,
  var.e0m = 1,
  var.e1m = 1,
  s.r = 2.4^2,
  cov.r = diag(4),
  s.lf = 2.4^2,
  s.lm = 2.4^2,
  eps = 0.01,
  nu = 4,
  Sigma.0 = diag(4)
)
}
\arguments{
\item{nsim}{Number of simulations}

\item{nburn}{Burn in number}

\item{Yvariable}{Binary indicating dependent variable for the couple disease status, 1 for disease}

\item{X.f_mat}{chemical exposure variables for female individual}

\item{X.m_mat}{chemical exposure variables for male individual}

\item{covariate_f_mat}{subject-specific covariates such as age or smoking status for female individual}

\item{covariate_m_mat}{subject-specific covariates such as age or smoking status for male individual}

\item{seed_num}{The seed for the random number generator. If NA, the default seed 678443068 is used}

\item{K}{latent class number. Default is 3}

\item{alpha.0f}{Initial value for fixed effect coefficient of the latent class variable for female individual}

\item{alpha.1f}{Initial value for fixed effect coefficient of the latent class variable for female individual}

\item{alpha.0m}{Initial value for fixed effect coefficient of the latent class variable for male individual}

\item{alpha.1m}{Initial value for fixed effect coefficient of the latent class variable for male individual}

\item{beta.0}{Initial value for Regression coefficients representing the association between the risk of Binary indicating variable for the couple and the latent class variables}

\item{beta.1f}{Initial value for Regression coefficients representing the association between the risk of Binary indicating variable for the couple and the latent class variables}

\item{beta.1m}{Initial value for Regression coefficients representing the association between the risk of Binary indicating variable for the couple and the latent class variables}

\item{beta.2}{Initial value for Regression coefficients representing the association between the risk of Binary indicating variable for the couple and the latent class variables}

\item{b.0f}{Initial value for random effect coefficient of the latent class variable for female individual}

\item{b.0m}{Initial value for random effect coefficient of the latent class variable for male individual}

\item{b.1f}{Initial value for random effect coefficient of the latent class variable for female individual}

\item{b.1m}{Initial value for random effect coefficient of the latent class variable for male individual}

\item{eta.0f}{Initial value for coefficient for the association between the risk of Binary nonzero measurement indicator for female individual and Nonzero measurement on the log scale for female individual}

\item{eta.1f}{Initial value for coefficient for the association between the risk of Binary nonzero measurement indicator for female individual and Nonzero measurement on the log scale for female individual}

\item{eta.0m}{Initial value for coefficient for the association between the risk of Binary nonzero measurement indicator for male individual and Nonzero measurement on the log scale for male individual}

\item{eta.1m}{coefficient for the association between the risk of Binary nonzero measurement indicator for male individual and Nonzero measurement on the log scale for male individual}

\item{Sigma.b}{Initial value for Variance covariance matrix for Nonzero measurement specific shared random effects vector}

\item{tau2.f}{Initial value for variace of V.f_mat Nonzero measurement on the log scale for female individual}

\item{tau2.m}{variace of V.m_mat Nonzero measurement on the log scale for male individual}

\item{lambda.1f}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for female individual}

\item{lambda.2f}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for female individual}

\item{lambda.3f}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for female individual}

\item{lambda.4f}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for female individual}

\item{lambda.5f}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for female individual}

\item{lambda.1m}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for male individual}

\item{lambda.2m}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for male individual}

\item{lambda.3m}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for male individual}

\item{lambda.4m}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for male individual}

\item{lambda.5m}{Initial value for Parameter vector for subject-specific covariates such as age, BMI or smoking status for male individual}

\item{mu.b0}{Initial value for prior distribution of beta0}

\item{mu.b1f}{Initial value for prior distribution of beta0 for female individual}

\item{mu.b1m}{Initial value for prior distribution of beta0 for male individual}

\item{mu.b2}{Initial value for prior distribution of beta0}

\item{sig2.b0}{Initial value for prior distribution of beta0}

\item{sig2.b1f}{Initial value for  prior distribution of beta0}

\item{sig2.b1m}{Initial value for  prior distribution of beta0}

\item{sig2.b2}{Initial value for  prior distribution of beta0}

\item{mu.a0f}{Initial value for noninformative normal prior distribution of alpha for female individual}

\item{mu.a1f}{Initial value for noninformative normal prior distribution of alpha female individual}

\item{mu.a0m}{Initial value for noninformative normal prior distribution for male individual alpha}

\item{mu.a1m}{Initial value for noninformative normal prior distribution for male individual alpha}

\item{sig2.a0f}{Initial value for noninformative normal prior distribution for female individual alpha}

\item{sig2.a1f}{Initial value for noninformative normal prior distribution for female individual alpha}

\item{sig2.a0m}{Initial value for noninformative normal prior distribution for male individual alpha}

\item{sig2.a1m}{Initial value for noninformative normal prior distribution for male individual alpha}

\item{mu.e0f}{Initial value for noninformative normal prior distribution for female individual eta0}

\item{mu.e1f}{Initial value for noninformative normal prior distribution for female individual eta1}

\item{mu.e0m}{Initial value for noninformative normal prior distribution for male individual eta0}

\item{mu.e1m}{Initial value for noninformative normal prior distribution for male individual eta1}

\item{sig2.e0f}{Initial value for noninformative normal prior distribution for female individual eta0}

\item{sig2.e1f}{Initial value for noninformative normal prior distribution for female individual eta1}

\item{sig2.e0m}{Initial value for noninformative normal prior distribution for male individual eta0}

\item{sig2.e1m}{Initial value for noninformative normal prior distribution for male individual eta0}

\item{a.tau}{Initial value for prior distribution for inverse-Gamma distribution tau square}

\item{b.tau}{Initial value for prior distribution for inverse-Gamma distribution tau square}

\item{mu.lf}{Initial value for prior distribution for female individual lambda}

\item{mu.lm}{Initial value for prior distribution for male individual lambda}

\item{Sigma.lf}{Initial value for prior distribution for female individual lambda}

\item{Sigma.lm}{Initial value for prior distribution for male individual lambda}

\item{s.b0}{Initial value for conditional posterior distribution of beta0 for adaptive Metropolis algorithm}

\item{s.b1f}{Initial value for conditional posterior distribution of female beta1 for adaptive Metropolis algorithm}

\item{s.b1m}{Initial value for conditional posterior distribution of male beta1 for adaptive Metropolis algorithm}

\item{s.b2}{Initial value for conditional posterior distribution of beta2 for adaptive Metropolis algorithm}

\item{var.b0}{Initial value for conditional posterior distribution of beta0 for adaptive Metropolis algorithm}

\item{var.b1f}{Initial value for conditional posterior distribution of female beta1 for adaptive Metropolis algorithm}

\item{var.b1m}{Initial value for conditional posterior distribution of male beta1 for adaptive Metropolis algorithm}

\item{var.b2}{Initial value for conditional posterior distribution of beta2 for adaptive Metropolis algorithm}

\item{s.e0f}{Initial value for conditional posterior distribution of female eta0 for adaptive Metropolis algorithm}

\item{s.e1f}{Initial value for conditional posterior distribution of female eta1 for adaptive Metropolis algorithm}

\item{s.e0m}{Initial value for conditional posterior distribution of male eta0 for adaptive Metropolis algorithm}

\item{s.e1m}{Initial value for conditional posterior distribution of male eta1 for adaptive Metropolis algorithm}

\item{var.e0f}{Initial value for conditional posterior distribution of female eta0 for adaptive Metropolis algorithm}

\item{var.e1f}{Initial value for conditional posterior distribution of female eta1 for adaptive Metropolis algorithm}

\item{var.e0m}{Initial value for conditional posterior distribution of male eta0 for adaptive Metropolis algorithm}

\item{var.e1m}{Initial value for conditional posterior distribution of male eta1 for adaptive Metropolis algorithm}

\item{s.r}{Initial value for conditional posterior distribution of random effect b for adaptive Metropolis algorithm}

\item{cov.r}{Initial value for conditional posterior distribution of random effect b for adaptive Metropolis algorithm}

\item{s.lf}{Initial value for conditional posterior distribution of female lambda for adaptive Metropolis algorithm}

\item{s.lm}{Initial value for conditional posterior distribution of male lambda for adaptive Metropolis algorithm}

\item{eps}{Initial value for beta.0}

\item{nu}{Initial value for Sigma.b}

\item{Sigma.0}{Initial value for Sigma.b}
}
\value{
A list of posterior estimates, latent class probability estimates and DIC
}
\description{
This function fit a couple-based joint latent class model with an interaction between a
couple(e.g., female and male partners) and High-dimensional semicontinuous chemical biomarker
for each partner of the couple. This formulation introduces a dependence structure between the chemical
patterns within a couple and between the chemical patterns and the risk of desease.
A Bayesian framework examines the chemical biomarker profile from each member of the couple
and the risk of disease. The complex chemical mixtures on each couple link to disease risk through unobserved
latent classes. we posit that two sets of latent classes, each characterizing the chemical mixture patterns
of one partner of the couple, are linked to the risk of disease through a logistic model with main and
interaction  effects between latent classes. The semicontinuous chimical biomarker viarables (1/4 zeros and
right-skewed non-zero values) are processed through Tobit modeling framework. Markov chain Monte Carlo
algorithms was used to obtain posterior estimates of model parameters.The user supplies data and priors,
and a list of posterior estimates of model parameters is returned.
}
\examples{
library(MCMCpack)
library(mvtnorm)
data(sampledata)
try1 <-lchemix:::JLchemix(nsim=12,nburn=2,Yvariable= sampledata[,1], X.f_mat = sampledata[,2:37],
X.m_mat = sampledata[,38:73], covariate_f_mat = sampledata[,74:78],
covariate_m_mat = sampledata[,79:83])
}
\references{
Beom Seuk Hwang, Zhen Chen,  Germaine M. Buck Louis, and Paul S. Albert. (2018)
\emph{A Bayesian multi-dimensional couple-based latent risk model with an application to infertility}.
Biometrics, 75, 315--325. \url{https://doi.org/10.1111/biom.12972}
}
