% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{plot.lcc}
\alias{plot.lcc}
\title{Diagnostic Plots for an \code{lcc} Object}
\usage{
\method{plot}{lcc}(x, which = c(1L:6L),
     caption = list("Residuals vs Fitted",
                    "Residuals vs Time",
                    "Residuals by Subject",
                    "Observed values vs Fitted values",
                    "Normal Q-Q Plot (Conditional residuals)",
                    "Normal Q-Q Plot (Random effects)"),
     sub.caption = NULL, main = NULL,
     panel = if(add.smooth) panel.smooth else points,
     add.smooth = TRUE, ask = TRUE,
     id.n = 3, labels.id = names(residuals(x)),
     label.pos = c(4, 2), cex.id = 0.75, cex.caption = 1,
     cex.oma.man = 1.25, ...)
}
\arguments{
\item{x}{An object of class \code{\link[lcc]{lcc}}, representing a
fitted longitudinal concordance correlation function.}

\item{which}{A numeric vector specifying which plots to display.
The valid range is c(1L:6L), corresponding to the plot types.}

\item{caption}{Captions for the plots, provided as a vector or list
of valid graphics annotations. Default captions are provided for each plot.}

\item{sub.caption}{A common sub-title for all plots; defaults to
\code{NULL}.}

\item{main}{The main title for the plots, displayed above the captions.}

\item{panel}{Panel function to be used for adding points to the plots.
Defaults to \code{panel.smooth} if \code{add.smooth} is \code{TRUE}, 
otherwise \code{points}.}

\item{add.smooth}{Logical; indicates whether a smoother should be added
to most plots. Defaults to \code{TRUE}.}

\item{ask}{Logical; if \code{TRUE}, prompts the user before displaying
each plot in a multi-plot layout. Defaults to \code{TRUE}.}

\item{id.n}{Number of extreme points to label in the first three plots.}

\item{labels.id}{Labels for the extreme points, defaulting to observation
numbers if \code{NULL}.}

\item{label.pos}{Positioning of labels in the left and right halves
of the graph, applicable for plots 1-3.}

\item{cex.id}{Magnification factor for point labels.}

\item{cex.caption}{Size of the plot captions.}

\item{cex.oma.man}{Size of the overall margin annotation (applies only
if \code{sub.caption} is above the figures in multi-plot layouts).}

\item{...}{Additional graphical parameters passed to \code{par}.}
}
\description{
Generates a series of diagnostic plots for evaluating the fit of a linear
mixed-effects model represented by an \code{lcc} object. This function
provides six types of plots, including residual plots, fitted value
comparisons, and normal Q-Q plots. Users can select specific plots or display
all by default.
}
\details{
The Q-Q plots use normalized residuals. Standardized residuals are pre-multiplied
by the inverse square-root factor of the estimated error correlation matrix,
while random effects are adjusted using the estimated variances from matrix G.
Simulation envelopes in Q-Q plots are generated using the \code{hnp} package.

The function is partly adapted from \code{\link[stats]{plot.lm}}.
}
\examples{
\dontrun{
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2)
plot(fm1)
}

}
\seealso{
\code{\link{lccPlot}}, \code{\link[lcc]{lcc}},
  \code{mtext}, \code{text}, \code{plotmath}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
