% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.lcc}
\alias{logLik.lcc}
\title{Extract Log-Likelihood of an \code{lcc} Object}
\usage{
\method{logLik}{lcc}(object, ..., REML)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{...}{further arguments passed to \code{\link{logLik}}.}

\item{REML}{an optional logical value.  If \code{TRUE} the
restricted log-likelihood is returned, else, if \code{FALSE}, the
log-likelihood is returned.}
}
\value{
If \code{REML=TRUE}, the default, returns the
  restricted log-likelihood value of the linear mixed-effects model;
  else the log-likelihood value
}
\description{
Extract Log-Likelihood of an \code{lcc} Object
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{

\dontrun{
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
logLik(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
