% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/lbaModel.R
\name{fptpdf}
\alias{fptpdf}
\alias{fptcdf}
\alias{n1PDF}
\alias{First_Passage_Time}
\title{First_Passage_Time}
\usage{
fptpdf(rt_r, parameter_r, is_positive_drift_r, verbose = FALSE)

fptcdf(rt_r, parameter_r, is_positive_drift_r, verbose = FALSE)

n1PDF(rt_r, parameter_r, is_positive_drift_r, verbose = FALSE)
}
\arguments{
\item{rt_r}{A numeric vector of response times (RTs).}

\item{parameter_r}{A numeric matrix of model parameters, with each row
representing a core model parameter and each column representing an
accumulator. Expected row (in fixed order): \code{A}, \code{b},
\code{mean_v}, \code{sd_v}, \code{st0}, and \code{t0}.}

\item{is_positive_drift_r}{A logical vector indicating whether the drift
rate must be positive for each trial.}

\item{verbose}{A logical value indicating whether to print debug information.}
}
\value{
A numeric vector of probabilities corresponding to input response
times.
}
\description{
The functions, \code{fptpdf}, \code{fptcdf}, and \code{n1PDF}, calculate
first passage time distributions for the Linear Ballistic Accumulation model.
This includes the probability density function \code{fptpdf}, the
cumulative distribution function \code{fptcdf}, and the node 1 density
function, \code{n1PDF}.
}
\details{
The three functions, respectively, are designed to:
\itemize{
\item \code{fptpdf}: Calculates the probability density function for
(PDF; 1 accumulator).
\item \code{fptcdf}: Calculates the cumulative distribution function
(CDF; 1 accumulator).
\item \code{n1PDF}: Calculates the node 1 PDF for the multi-accumulator
LBA model freeing the non-decision time.
\strong{node 1} refers to the accumulator passing the threshold first.
}
}
\examples{

#-------------------#
# n1PDF example
#-------------------#
if (requireNamespace("ggdmcModel", quietly = TRUE)) {
  BuildModel <- getFromNamespace("BuildModel", "ggdmcModel")

  model <- BuildModel(
    p_map = list(
      A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1",
      st0 = "1"
    ),
    match_map = list(M = list("s1" = "r1", "s2" = "r2")),
    factors = list(S = c("s1", "s2")),
    constants = c(sd_v = 1, st0 = 0),
    accumulators = c("r1", "r2"),
    type = "lba"
  )
}


#---------------------------------------#
pop_mean <- c(
  A = .4, B = 1.6, mean_v.true = 3.5, mean_v.false = 2.38,
  t0 = 0.05
)
pop_scale <- c(
  A = 2, B = .2, mean_v.true = .25, mean_v.false = .1,
  t0 = 0.01
)

if (requireNamespace("ggdmcPrior", quietly = TRUE)) {
  BuildPrior <- getFromNamespace("BuildPrior", "ggdmcPrior")

  pop_dist <- BuildPrior(
    p0 = pop_mean,
    p1 = pop_scale,
    lower = rep(NA, model@npar),
    upper = rep(NA, model@npar),
    dists = rep("tnorm", model@npar),
    log_p = rep(FALSE, model@npar)
  )
}

#---------------------------------------#
rt_model <- setLBA(model, population_distribution = pop_dist)
res_process_model <- simulate(rt_model)

param_list2mat <- function(param_list) {
  n_row <- length(param_list[[1]])
  n_col <- length(param_list)

  tmp <- matrix(NA, nrow = n_row, ncol = n_col)

  for (i in seq_len(n_col)) {
    tmp[, i] <- param_list[[i]]
  }
  t(tmp)
}

params_tmp <- list(
  A = c(0.74, 0.74),
  b = c(1.25 + 0.74, 1.25 + 0.74),
  mean_v = c(2.52, 1.50),
  sd_v = c(1.0, 1.0),
  st0 = c(0.0, 0.0),
  t0 = c(0.04, 0.04)
)

# Store the LBA parameter as a list of vectors
print(params_tmp)
# $A: 0.74 0.74
# $b: 1.99 1.99
# $mean_v: 2.52 1.50
# $sd_v: 1 1
# $st0: 0 0
# $t0: 0.04 0.04

# Convert it to a matrix, each row represents a parameter,
# and each column corresponds to an accumulator.
params <- param_list2mat(params_tmp)

print(params)
#      [,1] [,2]
# [1,] 0.74 0.74
# [2,] 1.99 1.99
# [3,] 2.52 1.50
# [4,] 1.00 1.00
# [5,] 0.00 0.00
# [6,] 0.04 0.04

n_acc <- 2
is_positive_drift <- rep(TRUE, n_acc)
res <- n1PDF(res_process_model$RT, params, is_positive_drift, TRUE)
cat("Print first 30 density values from the LBA node 1 function: \n")
print(head(round(res, 2), 30))

#----------------------------#
# fptpdf computes only 1 RT
#----------------------------#
mean_v <- 2.4
A <- 1.2
b <- 2.7
t0 <- .2
sd_v <- 1
st0 <- 0
positive_drift_r <- TRUE

params <- list(
  A = rep(A, 2),
  b = rep(b, 2),
  mean_v = rep(mean_v, 2),
  sd_v = rep(sd_v, 2),
  st0 = rep(st0, 2),
  t0 = rep(t0, 2)
)

n_accumulator <- length(params$A)
is_positive_drift <- rep(TRUE, n_accumulator)
params_mat <- param_list2mat(params)

RT <- 0.3
result <- fptpdf(RT, params_mat, is_positive_drift, TRUE)

#---------------------------------------#
# fptpdf and fptcdf computes a range RTs
#---------------------------------------#
RT <- seq(0, 10, .01) + t0
result1 <- fptpdf(RT, params_mat, is_positive_drift)
result2 <- fptcdf(RT, params_mat, is_positive_drift)
}
