% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_find_pid.R
\name{util_find_pid}
\alias{util_find_pid}
\title{R function to find PID of active applications}
\usage{
util_find_pid(tasks_running = t_running, pid_pattern = "terminal.exe")
}
\arguments{
\item{tasks_running}{\itemize{
\item string, vector with system tasks
}}

\item{pid_pattern}{\itemize{
\item string, pattern value to search application with
}}
}
\value{
string with system kill command to close selected application
}
\description{
Utility function to find PID of the working terminal.exe application
Function is created to generate a system call to programmatically close
any given application

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Function is executing a system command to get all processes running on the OS
Retrieved data is cleaned and organized to filter on required process
Function can also be used to track specific applications defined by the user
}
\examples{

library(magrittr)
library(tibble)
library(stringr)
library(dplyr)

#library(readr)


dir <- normalizePath(tempdir(),winslash = "/")


#tasks_running <- system("tasklist", intern = TRUE)
#writeLines(tasks_running, con = file.path(dir,'tasks_running.txt'))
#t_running <- readLines(con = file.path(dir,'tasks_running.txt'))

tasks_list = system.file("extdata", "tasks_running.txt",
                  package = "lazytrade")

t_running <- readLines(con = tasks_list)

#generate task kill command for this application
util_find_pid(tasks_running = t_running,
              pid_pattern = 'terminal.exe')

util_find_pid(tasks_running = t_running,
              pid_pattern = 'chrome.exe')


}
\author{
(C) 2021 Vladimir Zhbanko
}
