% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_if_optimize.R
\name{check_if_optimize}
\alias{check_if_optimize}
\title{Function check_if_optimize.}
\usage{
check_if_optimize(
  x,
  system_list,
  path_data,
  num_trades_to_consider = 3,
  profit_factor_limit = 0.7,
  write_mode = FALSE
)
}
\arguments{
\item{x}{\itemize{
\item dataframe containing trading results
}}

\item{system_list}{\itemize{
\item dataframe containing a table with magic numbers used by robots. Stored in file Setup.csv
}}

\item{path_data}{\itemize{
\item string, path to the folder where optimization file should be written
}}

\item{num_trades_to_consider}{\itemize{
\item Number of trades to calculate profit factor
}}

\item{profit_factor_limit}{\itemize{
\item Limit below which trading robot is considered not working properly
}}

\item{write_mode}{\itemize{
\item When true function will write result to the file located in the temporary directory
}}
}
\value{
function returns a dataframe with systems that should be optimized
}
\description{
Purpose of this function is to verify trading system functionality by analysing
profit factor on the last trades. Whenever trading robot has profit factor value below certain limit
function will write a file log indicating which trading systems need to be maintained.

Learn by example how to manipulate data

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
Whenever there will be not enough trades then empty file will be written to the destination
}
\examples{

library(lazytrade)
library(magrittr)
library(dplyr)
library(readr)
library(lubridate)

path_data <- normalizePath(tempdir(),winslash = "/")

file.copy(from = system.file("extdata", "Setup.csv", package = "lazytrade"),
          to = file.path(path_data, "Setup.csv"), overwrite = TRUE)

system_list <- read_csv(file.path(path_data, "Setup.csv"))

data(profit_factorDF)


# without writing to the file
check_if_optimize(x = profit_factorDF,
                  system_list = system_list,
                  path_data,
                  num_trades_to_consider = 3,
                  profit_factor_limit = 0.8,
                  write_mode = TRUE)


}
\author{
(C) 2019,2021 Vladimir Zhbanko
}
