% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuhauser.hothorn.test.R
\name{neuhauser.hothorn.test}
\alias{neuhauser.hothorn.test}
\title{Neuhauser--Hothorn Double Contrast Test for a Monotonic Trend in Variances}
\usage{
neuhauser.hothorn.test(
  y,
  group,
  location = c("median", "mean", "trim.mean"),
  tail = c("right", "left", "both"),
  trim.alpha = 0.25,
  bootstrap = FALSE,
  num.bootstrap = 1000,
  correction.method = c("none", "correction.factor", "zero.removal", "zero.correction")
)
}
\arguments{
\item{y}{a numeric vector of data values.}

\item{group}{factor of the data.}

\item{location}{the default option is \code{"median"} corresponding to the
robust Brown--Forsythe Levene-type procedure \insertCite{Brown_Forsythe_1974}{lawstat}; 
\code{"mean"} corresponds to the classical Levene's procedure
\insertCite{Levene_1960}{lawstat}, and \code{"trim.mean"} corresponds to the robust
Levene-type procedure using the group trimmed means.}

\item{tail}{the default option is \code{"right"}, corresponding to an increasing
trend in variances as the one-sided alternative;  \code{"left"} corresponds to a
decreasing trend in variances, and  \code{"both"} corresponds to any
(increasing or decreasing) monotonic trend in variances as the two-sided alternative.}

\item{trim.alpha}{the fraction (0 to 0.5) of observations to be trimmed from
each end of \code{x} before the mean is computed.}

\item{bootstrap}{a logical value identifying whether to implement bootstrap.
The default is \code{FALSE}, i.e., no bootstrap; if set to \code{TRUE},
the bootstrap method described in \insertCite{Lim_Loh_1996;textual}{lawstat}
for Levene's test is applied.}

\item{num.bootstrap}{number of bootstrap samples to be drawn when the \code{bootstrap}
argument is set to \code{TRUE}. The default value is 1000.}

\item{correction.method}{procedures to make the test more robust;
the default option is \code{"none"}; \code{"correction.factor"} applies the
correction factor described by \insertCite{OBrien_1978;textual}{lawstat} and
\insertCite{Keyes_Levy_1997;textual}{lawstat}; \code{"zero.removal"} performs the
structural zero removal method by \insertCite{Hines_Hines_2000;textual}{lawstat};
\code{"zero.correction"} performs a combination of the O'Brien's correction factor
and the Hines--Hines structural zero removal method \insertCite{Noguchi_Gel_2010}{lawstat}.
Note that the options \code{"zero.removal"} and \code{"zero.correction"} are only
applicable when the location is set to \code{"median"}, otherwise, \code{"none"} is applied.}
}
\value{
A list of class \code{"htest"} with the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the \eqn{p}-value of the test.}
\item{method}{type of test performed.}
\item{data.name}{a character string giving the name of the data.}
\item{non.bootstrap.p.value}{the \eqn{p}-value of the test without bootstrap method.}
}
\description{
The test statistic suggested by \insertCite{Neuhauser_Hothorn_2000;textual}{lawstat}.
}
\details{
The test statistic is based on 
the classical Levene's procedure (using the group means), 
the modified Brown--Forsythe Levene-type procedure (using the group medians),
or the modified Levene-type procedure (using the group trimmed means).
More robust versions of the test using the correction factor or structural zero
removal method are also available. Two options for calculating critical values,
namely, approximated and bootstrapped, are available.
By default, \code{NA}s are omitted from the data.
}
\examples{
data(pot)
neuhauser.hothorn.test(pot[, "obs"], pot[, "type"], location = "median", 
                       tail = "left", correction.method = "zero.correction")

## Bootstrap version of the test. The calculation may take up a few minutes
## depending on the number of bootstrap sampling.
neuhauser.hothorn.test(pot[, "obs"], pot[, "type"], location = "median", 
                       tail = "left", correction.method = "zero.correction", 
                       bootstrap = TRUE, num.bootstrap = 500)
                       
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{levene.test}}, \code{\link{lnested.test}}, 
\code{\link{ltrend.test}}, \code{\link{mma.test}}, \code{\link{robust.mmm.test}}
}
\author{
Kimihiro Noguchi, Yulia R. Gel
}
\keyword{htest}
\keyword{robust}
\keyword{variability}
