% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_var.R
\name{lavaan_var}
\alias{lavaan_var}
\title{Extract relevant variance indices from lavaan model}
\usage{
lavaan_var(fit, estimate = "r2", nice_table = FALSE, ...)
}
\arguments{
\item{fit}{lavaan fit object to extract covariance indices from}

\item{estimate}{What estimate to use, either the standardized
estimate ("r2", default), or unstandardized
estimate ("sigma2").}

\item{nice_table}{Logical, whether to print the table as a
\link[rempsyc:nice_table]{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{...}{Arguments to be passed to \link[rempsyc:nice_table]{rempsyc::nice_table}}
}
\value{
A dataframe of covariances/correlation, including the covaried
variables, the covariance/correlation, and corresponding p-value.
}
\description{
Extract relevant variance indices from lavaan
model through \link[lavaan:parameterEstimates]{lavaan::parameterEstimates} (when estimate = "sigma",
\code{est} column)) or \link[lavaan:standardizedSolution]{lavaan::standardizedsolution} (when estimate = "r2",
\code{est.std} column). R2 values are then calculated as \code{1 - est.std}, and
the new \emph{p} values for the R2, with the following formula:
\code{stats::pnorm((1 - est) / se)}.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

(regression <- list(
  ageyr = c("visual", "textual", "speed"),
  grade = c("visual", "textual", "speed")
))

(covariance <- list(speed = "textual", ageyr = "grade"))

HS.model <- write_lavaan(
  regression = regression, covariance = covariance,
  latent = latent, label = TRUE
)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data = HolzingerSwineford1939)
lavaan_var(fit)
\dontshow{\}) # examplesIf}
}
