% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_ncore.R
\name{lsm_p_ncore}
\alias{lsm_p_ncore}
\title{NCORE (patch level)}
\usage{
lsm_p_ncore(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell

#' @details
\deqn{NCORE = n_{ij}^{core}}
where \eqn{n_{ij}^{core}} is the number of disjunct core areas.

NCORE is a 'Core area metric'. A cell is defined as core if the cell has no
neighbour with a different value than itself (rook's case). The metric
counts the disjunct core areas, whereby a core area is a 'patch within the
patch' containing only core cells. It describes patch area and shape
simultaneously (more core area when the patch is large, however, the shape
must allow disjunct core areas). Thereby, a compact shape (e.g. a square)
will contain less disjunct core areas than a more irregular patch.
\subsection{Units}{None}
\subsection{Range}{NCORE >= 0}
\subsection{Behaviour}{NCORE = 0 when CORE = 0, i.e. every cell in patch is
edge. Increases, without limit, as core area increases and patch shape
allows disjunct core areas (i.e. patch shape becomes rather complex).}}
}
\value{
tibble
}
\description{
Number of core areas (Core area metric)
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_p_ncore(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_c_dcore_mn}},
\code{\link{lsm_c_dcore_sd}},
\code{\link{lsm_c_dcore_cv}},
\code{\link{lsm_c_ndca}}, \cr
\code{\link{lsm_l_dcore_mn}},
\code{\link{lsm_l_dcore_sd}},
\code{\link{lsm_l_dcore_cv}},
\code{\link{lsm_l_ndca}}
}
