% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_extras.R
\name{get_class_patches}
\alias{get_class_patches}
\title{get_class_patches}
\usage{
get_class_patches(landscape_mat, classes, directions)
}
\arguments{
\item{landscape_mat}{A matrix object}

\item{classes}{A vector with unique values (output of get_unique_values_int)}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
list with matrices of patches for each class
}
\description{
Get patches for each class
}
\details{
Calculate patches for each class
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
classes <- landscapemetrics:::get_unique_values_int(landscape_mat)
class_patches <- get_class_patches(landscape_mat, classes, directions = 8)

}
\keyword{internal}
