% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{im.csv.read}
\alias{im.csv.read}
\title{Read csv File to Incidence Matrix}
\usage{
im.csv.read(
  filename,
  header = FALSE,
  characterencoding = "iso-8859-1",
  remove.hapax = FALSE
)
}
\arguments{
\item{filename}{The filename to uploaded (must be in \code{.csv} format).}

\item{header}{If the \code{.csv} file contains a header. Default is \code{FALSE}.}

\item{characterencoding}{File encoding as used by \code{\link[readr]{locale}}. Default is \code{"iso-8859-1"} to handle special characters.}

\item{remove.hapax}{Remove any row or column which has a sum of 1 (i.e., is only attested once), since they do not directly contribute to the result of the seriation. Default is \code{FALSE}.}
}
\value{
An incidence matrix of binary values (0 = row/column occurrence is absence; 1 = row/column occurrence is present).
}
\description{
Wrapper around the \code{\link[readr]{read_csv}} function from the \code{readr} package \insertCite{wickham_readr_2024}{lakhesis}. Read a \code{.csv} file in which the first column represents row elements and the second column represents column elements, and convert it into an incidence matrix.
}
\references{
\insertAllCited{}
}
