% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustVertex.R
\name{adjustVertex}
\alias{adjustVertex}
\title{Modify the coordinates of given vertexes of a simplex}
\usage{
adjustVertex(simplex, newcoords, overwrite = FALSE)
}
\arguments{
\item{simplex}{object of class \code{smplx} with the simplex
information. See \code{\link{labsimplex}}}

\item{newcoords}{List with elements named like the vertexes to be modified.
Each element must have a vector with the actual (ordered)
coordinates used in the experiment. \code{NA} values may
be used to indicate unchanged coordinates}

\item{overwrite}{logical argument. If \code{TRUE}, the output simplex will
replace the one provided in the \code{simplex} parameter.
Default \code{overwrite = FALSE}}
}
\value{
An object of class \code{smplx} with the modified simplex information.
}
\description{
Changes the coordinates of previously generated vertexes when slight
differences were impossible to avoid at the moment of setting the experiment
variables (e.g. small differences in mass components when preparing a
mixture). This function allows the correction of the vertexes of a simplex
in order to produce movements of the simplex based on the actual
coordinates.
}
\examples{
simplex <- labsimplex(n = 3, start = c(7, 25, 0.15),
                      stepsize = c(0.2, 5, 0.02))
adjustVertex(simplex = simplex, newcoords = list(Vertex.1 = c(7.1, NA, NA),
                                                 Vertex.3 = c(6.9, NA, 0.155)),
             overwrite = TRUE)
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
