% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_rename.R
\name{lama_rename}
\alias{lama_rename}
\alias{lama_rename.lama_dictionary}
\alias{lama_rename_}
\alias{lama_rename_.lama_dictionary}
\title{Rename multiple variable translations in a \link[=new_lama_dictionary]{lama_dictionary} object}
\usage{
lama_rename(.data, ...)

\method{lama_rename}{lama_dictionary}(.data, ...)

lama_rename_(.data, old, new)

\method{lama_rename_}{lama_dictionary}(.data, old, new)
}
\arguments{
\item{.data}{A \link[=new_lama_dictionary]{lama_dictionary} object, holding the variable translations}

\item{...}{One or more unquoted expressions separated by commas. Use named arguments, e.g. \code{new_name = old_name}, to rename selected variables.}

\item{old}{A character vector holding the names of the variable translations,
that should be renamed.}

\item{new}{A character vector holding the new names of the variable
translations.}
}
\value{
The updated \link[=new_lama_dictionary]{lama_dictionary} class object.
}
\description{
The functions \code{\link[=lama_rename]{lama_rename()}} and \code{\link[=lama_rename_]{lama_rename_()}}
are used to rename one or more variable translations inside of a
\link[=new_lama_dictionary]{lama_dictionary} class object.
The function \code{\link[=lama_rename]{lama_rename()}} uses non-standard evaluation,
whereas \code{\link[=lama_rename_]{lama_rename_()}} is the standard evaluation alternative.
}
\examples{
  # initialize lama_dictinoary
  dict <- new_lama_dictionary(
    country = c(uk = "United Kingdom", fr = "France", NA_ = "other countries"),
    language = c(en = "English", fr = "French"),
    result = c("1" = "Very good", "2" = "Good", "3" = "Not so good")
  )

  ## Example-1: Usage of 'lama_rename'
  # rename translations 'result' and 'language' to 'res' and 'lang'
  dict_new <- lama_rename(dict, res = result, lang = language)
  dict_new
  
  ## Example-2: Usage of 'lama_rename_'
  # rename translations 'result' and 'language' to 'res' and 'lang'
  dict_new <- lama_rename_(dict, c("result", "language"), c("res", "lang"))
  dict_new
}
\seealso{
\code{\link[=lama_translate]{lama_translate()}}, \code{\link[=lama_to_factor]{lama_to_factor()}}, \code{\link[=lama_translate_all]{lama_translate_all()}},
\code{\link[=lama_to_factor_all]{lama_to_factor_all()}}, \code{\link[=new_lama_dictionary]{new_lama_dictionary()}},
\code{\link[=as.lama_dictionary]{as.lama_dictionary()}}, \code{\link[=lama_select]{lama_select()}}, \code{\link[=lama_mutate]{lama_mutate()}},
\code{\link[=lama_merge]{lama_merge()}}, \code{\link[=lama_read]{lama_read()}}, \code{\link[=lama_write]{lama_write()}}
}
