% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{gg_kronos_circle}
\alias{gg_kronos_circle}
\title{A plotting method for circadian plots using 'ggplot2'.}
\usage{
gg_kronos_circle(kronosOut)
}
\arguments{
\item{kronosOut}{an output object from the main \code{kronos} function.}
}
\value{
a 'ggplot2' compatible object.
}
\description{
Wrapper around 'ggplot2' to make circadian circleplots.
}
\examples{
#Load prepared data stored in Kronos library
data("kronos_demo")
output <- kronos(formula = Variable_1 ~ time(Timepoint), 
data = onevariable, period = 24, verbose = TRUE, pairwise = FALSE)

#Extracting data from the output object:
getKronos_fit(output)
getKronos_trace(output)
getKronos_groupwise(output)

#Plotting:
gg_kronos_circle(output)
gg_kronos_sinusoid(output)

#For high-dimensional data, use fw_kronos:
out_list = fw_kronos(x = bigdata[1:50,], formula = ~ Group + time(Timepoint), 
metadata = bigmeta, period = 24, verbose = FALSE, pairwise = TRUE) 

#Extracting data from the output object: 
kronosListToTable(out_list)


#Plotting:
gg_kronos_acrogram(out_list)
}
