% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getKronos_params}
\alias{getKronos_params}
\title{Get Results from \code{KronosOut} Object}
\usage{
getKronos_params(kronosOut)
}
\arguments{
\item{kronosOut}{a \code{kronosOut} output object.}
}
\value{
The names and values of additional circadian model parameters, mostly for plotting purposes.
}
\description{
These functions provides a unified wrapper to retrieve results
 from a \code{kronosOut} object.
}
\examples{
#Load prepared data stored in 'kronos' library
data("kronos_demo")
output <- kronos(formula = Variable_1 ~ time(Timepoint), 
data = onevariable, period = 24, verbose = TRUE, pairwise = FALSE)

#Extracting data from the output object:
getKronos_fit(output)
getKronos_trace(output)
getKronos_groupwise(output)

#Plotting:
gg_kronos_circle(output)
gg_kronos_sinusoid(output)

#For high-dimensional data, use fw_kronos:
out_list = fw_kronos(x = bigdata[1:50,], formula = ~ Group + time(Timepoint), 
metadata = bigmeta, period = 24, verbose = FALSE, pairwise = TRUE) 

#Extracting data from the output object: 
kronosListToTable(out_list)


#Plotting:
gg_kronos_acrogram(out_list)

}
