% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_01_kRp.text.R
\docType{class}
\name{kRp.text,-class}
\alias{kRp.text,-class}
\alias{kRp_text}
\alias{kRp.text-class}
\title{S4 Class kRp.text}
\description{
This class is used for objects that are returned by \code{\link[koRpus:treetag]{treetag}} or \code{\link[koRpus:tokenize]{tokenize}}.
}
\section{Slots}{

\describe{
\item{\code{lang}}{A character string,
      naming the language that is assumed for the tokenized text in this object.}

\item{\code{desc}}{Descriptive statistics of the tagged text.}

\item{\code{tokens}}{Results of the called tokenizer and POS tagger. The data.frame usually has eleven columns:
\describe{
  \item{\code{doc_id}:}{Factor, optional document identifier.}
  \item{\code{token}:}{Character, the tokenized text.}
  \item{\code{tag}:}{Factor, POS tags for each token.}
  \item{\code{lemma}:}{Character, lemma for each token.}
  \item{\code{lttr}:}{Integer, number of letters.}
  \item{\code{wclass}:}{Factor, word class.}
  \item{\code{desc}:}{Factor, a short description of the POS tag.}
  \item{\code{stop}:}{Logical, \code{TRUE} if token is a stopword.}
  \item{\code{stem}:}{Character, stemmed token.}
  \item{\code{idx}:}{Integer, index number of token in this document.}
  \item{\code{sntc}:}{Integer, number of sentence in this document.}
}
This data.frame structure adheres to the "Text Interchange Formats" guidelines set out by rOpenSci[1].}

\item{\code{features}}{A named logical vector,
      indicating which features are available in this object's \code{feat_list} slot.
Common features are listed in the description of the \code{feat_list} slot.}

\item{\code{feat_list}}{A named list with optional analysis results or other content as used by the defined \code{features}:
\itemize{
  \item{\code{hyphen} }{A named list of objects of class \code{\link[sylly:kRp.hyphen-class]{kRp.hyphen}}.}
  \item{\code{readability} }{A named list of objects of class \code{\link[koRpus:kRp.readability-class]{kRp.readability}}.}
  \item{\code{lex_div} }{A named list of objects of class \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}.}
  \item{\code{freq} }{A list with additional results of \code{\link[koRpus:freq.analysis]{freq.analysis}}.}
  \item{\code{corp_freq} }{An object of class \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}},
      e.g., results of a call to
    \code{\link[koRpus:read.corp.custom]{read.corp.custom}}.}
  \item{\code{diff} }{Additional results of calls to a method like \code{\link[koRpus:textTransform]{textTransform}}.}
  \item{\code{doc_term_matrix} }{A sparse document-term matrix,
      as produced by \code{\link[koRpus:docTermMatrix]{docTermMatrix}}.}
}
See the \code{\link[koRpus:kRp.text_get-methods]{getter and setter methods}} for easy access to these sub-slots.
There can actually be any number of additional features,
      the above is just a list of those already defined by this package.}
}}

\note{
There is also \code{as()} methods to transform objects from other koRpus classes into kRp.text.
}
\section{Contructor function}{

Should you need to manually generate objects of this class (which should rarely be the case),
      the contructor function 
\code{kRp_text(...)} can be used instead of
\code{new("kRp.text", ...)}.
}

\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
\keyword{classes}
