% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitxl.R
\name{knitxl}
\alias{knitxl}
\title{Knit a Document to an XLSX file}
\usage{
knitxl(
  input,
  output = NULL,
  text = NULL,
  quiet = FALSE,
  envir = parent.frame(),
  encoding = "UTF-8"
)
}
\arguments{
\item{input}{Path to the input file.}

\item{output}{Path to the output file for \code{knitxl()}. If \code{NULL}, this
function will try to guess a default, which will be under the current
working directory.}

\item{text}{A character vector. This is an alternative way to provide the
input file.}

\item{quiet}{Boolean; suppress the progress bar and messages?}

\item{envir}{Environment in which code chunks are to be evaluated, for
example, \code{\link{parent.frame}()}, \code{\link{new.env}()}, or
\code{\link{globalenv}()}).}

\item{encoding}{Encoding of the input file; always assumed to be UTF-8 (i.e.,
this argument is effectively ignored).}
}
\value{
The compiled document is written into the output file, and the path
of the output file is returned invisibly.
}
\description{
This function takes an input file, extracts the R code in it according to a
list of patterns, evaluates the code and writes the output in an XLSX
spreadsheet file.
}
\examples{
  library(knitxl)
  path_to_input <- system.file("examples", "knitxl-minimal.Rmd", package = "knitxl")
  path_to_output <- "knitxl-minimal.xlsx"
  knitxl(path_to_input, output = path_to_output)  # will generate knitxl-minimal.xlsx
  unlink(path_to_output)

}
