% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcabiplot.R
\name{pcabiplot}
\alias{pcabiplot}
\title{Biplot of a PCA object}
\usage{
pcabiplot(
  PC,
  x = "PC1",
  y = "PC2",
  var.line = TRUE,
  colobj = rep(1, nrow(PC$x)),
  o.size = 1
)
}
\arguments{
\item{PC}{A pca object generated by \code{prcomp} function.}

\item{x}{X axis (see \strong{Details}).}

\item{y}{Y axis (see \strong{Details}).}

\item{var.line}{A logical input, if variable lines are plotted.}

\item{colobj}{A vector to provide color in the objects (see
\strong{Details}).}

\item{o.size}{A numeric number to set the object size.}
}
\value{
Function returns a plot of pca.
}
\description{
This function creates a biplot from a pca object, which is
generated by the \code{prcomp} function from the \pkg{stats} package.
}
\details{
This is a function to plot a pca biplot from a pca object. The x
and y axes can be supplied with any principle component. The length of the
\code{colobj} vector has to be equal to the number of objects. This argument
controls the color of the objects and is very convenient to explore the
clustering result. The default value is that all object have the same color.
}
\examples{
pcadat <- prcomp(iris[,1:4], scale. = TRUE)
pcabiplot(pcadat)

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
