% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadUCSCgenome.R
\name{downloadUCSCgenome}
\alias{downloadUCSCgenome}
\title{Function downloads chromosome-separated fasta genome sequences from the UCSC
database. Users can specify a genome name, an output folder, and a specific
chromosome or chromosomes. There's an option to choose the download method as well.}
\usage{
downloadUCSCgenome(genome.name, output.path, chr.name, method = "curl")
}
\arguments{
\item{genome.name}{Genome name (e.g., hg19, hg38, mm19).}

\item{output.path}{Output folder for the downloaded sequences.}

\item{chr.name}{Specific chromosome to download; defaults to all if unspecified.}

\item{method}{Download method for the \code{download.file} function.}
}
\value{
An output folder containing chromosome-separated fasta files.
}
\description{
Function downloads chromosome-separated fasta genome sequences from the UCSC
database. Users can specify a genome name, an output folder, and a specific
chromosome or chromosomes. There's an option to choose the download method as well.
}
