% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSC_Genome.R
\name{UCSC_Genome}
\alias{UCSC_Genome}
\title{Class constructor - build Genome object}
\description{
Class constructor - build Genome object

Class constructor - build Genome object
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{root_path}}{A path to a directory containing chromosome-separated
fasta files.}

\item{\code{genome_name}}{A genome name.}

\item{\code{paths}}{Individual chromosome sequence files.}

\item{\code{seq}}{A chromosome-named list of sequences.}

\item{\code{seq_len}}{A chromosome-named vector of sequence length.}

\item{\code{load_limit}}{Maximum chromosome sequences loaded.}

\item{\code{mask}}{Genome mask status: "hard", "soft", or "none".}

\item{\code{info_file}}{Path to info file with pre-computed values.}

\item{\code{chr_names}}{Chromosome names.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UCSC_Genome-new}{\code{UCSC_Genome$new()}}
\item \href{#method-UCSC_Genome-print}{\code{UCSC_Genome$print()}}
\item \href{#method-UCSC_Genome-get_length}{\code{UCSC_Genome$get_length()}}
\item \href{#method-UCSC_Genome-get_content}{\code{UCSC_Genome$get_content()}}
\item \href{#method-UCSC_Genome-clone}{\code{UCSC_Genome$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UCSC_Genome-new"></a>}}
\if{latex}{\out{\hypertarget{method-UCSC_Genome-new}{}}}
\subsection{Method \code{new()}}{
Create a new Genome class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UCSC_Genome$new(genome.name, root.path, mask, load.limit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genome.name}}{A genome name. UCSC genome is included with kmeRtone.}

\item{\code{root.path}}{Path to a directory of user-provided genome FASTA files or
the destination to save the NCBI/UCSC downloaded reference genome files.}

\item{\code{mask}}{Genome mask status: "hard", "soft", or "none". Default is
"none".}

\item{\code{load.limit}}{Maximum chromosome sequences loaded. Default is 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Genome} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UCSC_Genome-["></a>}}
\if{latex}{\out{\hypertarget{method-UCSC_Genome-[}{}}}
\subsection{Method \code{[()}}{
Calling chromosome sequence by loading on demand.
Maximum load is determine by load_limit field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UCSC_Genome$[(chr.names, reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chr.names}}{Chromosome name. It can be a vector of chromosomes.}

\item{\code{reload}}{Reload the sequence from the root_path.
Default is FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single or list of sequence of requested chromosome.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UCSC_Genome-print"></a>}}
\if{latex}{\out{\hypertarget{method-UCSC_Genome-print}{}}}
\subsection{Method \code{print()}}{
Print summary of \code{Genome} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UCSC_Genome$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Message of \code{Genome} object summary.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UCSC_Genome-get_length"></a>}}
\if{latex}{\out{\hypertarget{method-UCSC_Genome-get_length}{}}}
\subsection{Method \code{get_length()}}{
Get chromosome length from pre-calculated length
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UCSC_Genome$get_length(chr.names, recalculate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chr.names}}{Chromosome name. It can be a vector of chromosomes.}

\item{\code{recalculate}}{Recalculate the pre-calculated length.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A chromosome-named vector of length value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UCSC_Genome-get_content"></a>}}
\if{latex}{\out{\hypertarget{method-UCSC_Genome-get_content}{}}}
\subsection{Method \code{get_content()}}{
Get pre-calculated sequence content e.g. G+C content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UCSC_Genome$get_content(chr.names, seq, recalculate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chr.names}}{Chromosome name. It can be a vector of chromosomes.}

\item{\code{seq}}{Sequence to count. e.g. c("G", "C")}

\item{\code{recalculate}}{Recalculate the pre-calculated length.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A chromosome-named vector of sequence content.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UCSC_Genome-clone"></a>}}
\if{latex}{\out{\hypertarget{method-UCSC_Genome-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UCSC_Genome$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
