% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pacoplot.R
\name{pacoplot}
\alias{pacoplot}
\title{Parallel Coordinates Plot for Clustering}
\usage{
pacoplot(data, clusters, colorScheme = "schemeCategory10",
  width = NULL, height = NULL, labelSizes = NULL, lineSize = NULL,
  measures = NULL)
}
\arguments{
\item{data}{A dataframe of numeric columns.}

\item{clusters}{A named integer matrix of clusters where names are the row names
of the above dataframe and integers are the integer value of the row's associated cluster.
This can be obtained from a function such as \code{ stats::kmeans()$cluster }.}

\item{colorScheme}{The color scheme of the plot. May be a pre-configured D3 ordinal color scheme
or a vector of html colors (hex or named) of the same length as the number of clusters.}

\item{width}{The width of the plot window.}

\item{height}{The height of the plot window.}

\item{labelSizes}{A number or list of any combination of parameters shown that define the label sizes.
\code{ list(yaxis = 12, yticks = 10, tooltip = 15) }}

\item{lineSize}{A number to adjust the size of the lines.}

\item{measures}{A list of functions that is any combination of parameters shown that define the measurements for intervals and average lines displayed.
Defaults to the options shown (median and 1st and 3rd quartile). \cr
\code{ list(avg = median, upper = function(x){return(quantile(x, c(0.75)))}, lower = function(x){return(quantile(x, c(0.25)))}) }}
}
\description{
Creates an interactive parallel coordinates plot detailing each
dimension and the cluster associated with each observation.
}
\details{
\itemize{
  \item Hover over lines to display row label
  \item Click on a line to fade out all lines except the associated cluster
  \item Click on another line to bold this line as well
  \item Clicking a second time on a line will fade it out
}
}
\examples{

# Barebones
df <- state.x77
clus <- kmeans(df, 5)$cluster
pacoplot(data = df, clusters = clus)

# With options
df <- state.x77
clus <- kmeans(df, 5)$cluster
pacoplot(data = df, clusters = clus,
         colorScheme = c("red", "green", "orange", "blue", "yellow"),
         labelSizes = list(yaxis = 16, yticks = 12),
         measures = list(avg = mean))


}
