% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_method_sort.klausuR.R
\docType{methods}
\name{sort}
\alias{sort}
\alias{sort,klausuR-method}
\alias{sort,-methods}
\alias{sort.klausuR,klausuR-method}
\title{Sort method for S4 objects of class klausuR}
\usage{
sort(x, decreasing = FALSE, ...)

\S4method{sort}{klausuR}(x, decreasing = FALSE, sort.by = c())
}
\arguments{
\item{x}{An object of class \code{klausuR}}

\item{decreasing}{Logical, whether sorting should be sone increasing or decreasing.}

\item{...}{Additional arguments.}

\item{sort.by}{An optional character string naming a variable to sort the results by. Defaults to \code{c()},
      i.e. no re-ordering.}
}
\description{
Returns the given object,
      with global results and anonymized results sorted by the given variable.
}
\examples{
\dontrun{
klsr.obj <- klausur(data.obj)
sort(klsr.obj, sort.by="Points")
}
}
\seealso{
\code{\link[klausuR:klausur]{klausur}}
}
\author{
m.eik michalke \email{meik.michalke@uni-duesseldorf.de}
}
\keyword{methods}
