% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen_d_to_r.R
\name{cohen_d_to_r}
\alias{cohen_d_to_r}
\title{Convert Cohen's d to r}
\usage{
cohen_d_to_r(d = NULL, n1 = NULL, n2 = NULL, d_var = NULL)
}
\arguments{
\item{d}{Cohen's d (the input can be a vector of values)}

\item{n1}{sample size in the first of two group (the input can be a
vector of values)}

\item{n2}{sample size in the second of two group (the input can be a
vector of values)}

\item{d_var}{(optional argument) variance of d
(the input can be a vector of values). If this argument receives an
input, variance of r will be returned as well.}
}
\value{
the output will be a vector of correlation values
(and variances of r if the argument d_var received an input)
}
\description{
Convert d (standardized mean difference or Cohen's d) to r (correlation),
as illustrated in Borenstein et al. (2009, p. 48, ISBN: 978-0-470-05724-7)
}
\examples{
\dontrun{
cohen_d_to_r(1)
cohen_d_to_r(d = 1:3)
cohen_d_to_r(d = 1:3, n1 = c(100, 200, 300), n2 = c(50, 250, 900))
cohen_d_to_r(1.1547)
cohen_d_to_r(d = 1.1547, d_var = .0550)
cohen_d_to_r(d = 1:2, d_var = 1:2)
}
}
