% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/khis_cred.R
\name{khis_display_name}
\alias{khis_display_name}
\title{Retrieve the Configured Display Name}
\usage{
khis_display_name(auth = NULL)
}
\arguments{
\item{auth}{(Optional) An auth object containing DHIS2 credentials.
If not provided, the function retrieves the display name from the global auth object.}
}
\value{
The display name as a string, or \code{NULL} if no profile or display name is available.
}
\description{
This function returns the display name from the configured profile in the provided
auth object. If \code{auth} is not provided, it falls back to the global auth credentials.
}
\examples{

\dontrun{
    # Set the credentials using global .auth object
    khis_cred(username = 'DHIS2 username',
              password = 'DHIS2 password',
              base_url = 'https://dhis2-instance/api')

    # Retrieve the display name from the global .auth profile
    khis_display_name()

    # Clear credentials
    khis_cred_clear()

    # Retrieve the display name again (expect 'NULL')
    khis_display_name()
}
}
\seealso{
Other credential functions: 
\code{\link{khis_base_url}()},
\code{\link{khis_cred}()},
\code{\link{khis_cred_clear}()},
\code{\link{khis_has_cred}()},
\code{\link{khis_username}()}
}
\concept{credential functions}
