% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{diagnoses}
\alias{diagnoses}
\title{Psychiatric diagnoses}
\format{
\subsection{\code{diagnoses}}{

A matrix with 30 rows and 6 columns:
\describe{
\item{rater1}{1st rating of some six raters}
\item{rater2}{2nd rating of some six raters}
\item{rater3}{3rd rating of some six raters}
\item{rater4}{4th rating of some six raters}
\item{rater5}{5th rating of some six raters}
\item{rater6}{6th rating of some six raters}
}
}
}
\usage{
diagnoses
}
\description{
N = 30 patients were given one of k = 5 diagnoses by some n = 6
psychiatrists out of 43 psychiatrists in total. The diagnoses are
\enumerate{
\item Depression
\item PD (=Personality Disorder)
\item Schizophrenia
\item Neurosis
\item Other
}
}
\details{
A total of 43 psychiatrists provided diagnoses. In the actual
study (Sandifer, Hordern, Timbury, & Green, 1968), between 6 and 10
psychiatrists from the pool of 43 were unsystematically selected to diagnose
a subject. Fleiss randomly selected six diagnoses per subject to bring the
number of assignments per patient down to a constant of six.

As there is not a fixed set of six raters the ratings from the same column
are not related to each other. Therefore, compared to the dataset with the
same name in package \code{irr}, we applied a permutation of the six ratings.
}
\references{
Sandifer, M. G., Hordern, A., Timbury, G. C., & Green, L. M.
Psychiatric diagnosis: A comparative study in North Carolina, London and
Glasgow. British Journal of Psychiatry, 1968, 114, 1-9.

Fleiss, J. L. Measuring nominal scale agreement among many
raters. Psychological Bulletin, 1971, 76(5), 378–382.
\doi{10.1037/h0031619}
}
\seealso{
This dataset is also available as \code{diagnoses} in the irr-package on
CRAN.
}
\keyword{datasets}
