% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jfunctions.R
\name{qc}
\alias{qc}
\title{qc}
\usage{
qc(u, cc = sqrt(5/3))
}
\arguments{
\item{u}{Numeric vector.}

\item{cc}{Numeric constant, defaults to \eqn{\sqrt(5/3)}.}
}
\value{
Vector of same length and mode as \code{u}.
}
\description{
Coefficient \eqn{q_c(u)} of eq. (15.15) in Eichner (2017).
}
\details{
\eqn{q_c(u) = 2/5 * c^5 / (3 - c^2) * (1 - 2 * u)}

For further details see p. 297 f. in Eichner (2017) and/or Eichner & Stute
(2013).
}
\note{
\eqn{q_c(u)} should be undefined for \eqn{c = \sqrt 3}, but \code{qc}
      is here implemented to return \code{Inf * (1 - 2*u)} if \code{cc}
      contains R's value of \code{sqrt(3)}.
}
\examples{
\donttest{
u <- c(0, 1)   # seq(0, 1, by = 0.1)
c0 <- expression(sqrt(5/3))
c1 <- expression(sqrt(3) - 0.05)
cgrid <- seq(1.4, 1.6, by = 0.1)
cvals <- c(eval(c0), cgrid, eval(c1))

Y <- sapply(cvals, function(cc, u) qc(u, cc = cc), u = u)
cols <- rainbow(ncol(Y), end = 9/12)
matplot(u, Y, type = "l", lty = "solid", col = cols,
  ylab = expression(q[c](u)))
abline(h = 0, lty = "dashed")
legend("topright", title = "c", legend = c(c0, cgrid, c1),
  lty = 1, col = cols, cex = 0.8)
}

}
