#2345678901234567890123456789012345678901234567890123456789012345678901234567890
#' Kernel Adjusted Density Estimation and Regression
#'
#' Package of functions to compute kernel estimators for
#' \itemize{
#'  \item nonparametric density estimation using a data-adjusted kernel or an
#'        appropriate rank-transformation, and for
#'  \item nonparametric regression using a data-adjusted kernel.
#' }
#'
#' The functions are based on the theory laid out in the following papers:
#' \itemize{
#'  \item Srihera, R., Stute, W. (2011): Kernel adjusted density
#'        estimation. Statistics and Probability Letters 81, 571 - 579,
#'        URL \url{http://dx.doi.org/10.1016/j.spl.2011.01.013}.
#'  \item Eichner, G., Stute, W. (2012): Kernel adjusted nonparametric
#'        regression. Journal of Statistical Planning and Inference 142,
#'        2537 - 2544, URL \url{http://dx.doi.org/10.1016/j.jspi.2012.03.011}.
#'  \item Eichner, G., Stute, W. (2013): Rank Transformations in Kernel
#'        Density Estimation. Journal of Nonparametric Statistics 25(2),
#'        427 - 445, URL \url{http://dx.doi.org/10.1080/10485252.2012.760737}.
#' %  \item Eichner, G., Stute, W. (2015): Rank-Based Kernel Smoothing --
#' %        \eqn{L_2}-approach. Talk presented at the 12th Workshop on
#' %        Stochastic Models, Statistics and Their Applications in Wroclaw,
#' %        Poland, February 2015.
#' }
#'
#' A very brief summary of the three papers above and sort of a vignette is
#' presented in Eichner, G. (2017): Kader - An R package for nonparametric
#' kernel adjusted density estimation and regression. In: Ferger, D., et al.
#' (eds.): From Statistics to Mathematical Finance, Festschrift in Honour of
#' Winfried Stute. Springer International Publishing. To appear in Jan. 2018.
#' DOI then(!) presumably: 10.1007/978-3-319-50986-0.
#'
#' @docType package
#' @name kader
NULL
