% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_poisson.R
\name{poisson_pred}
\alias{poisson_pred}
\title{poisson_pred}
\usage{
poisson_pred(conj.param, outcome = NULL, parms = list(), pred.cred = 0.95)
}
\arguments{
\item{conj.param}{list or data.frame: The parameters of the conjugated distributions of the linear predictor.}

\item{outcome}{numeric or matrix (optional): The observed values at the current time. Not used in this function.}

\item{parms}{list (optional): A list of extra parameters for the model. Not used in this function.}

\item{pred.cred}{numeric: the desired credibility for the credibility interval.}
}
\value{
A list containing the following values:
\itemize{
   \item pred numeric/matrix: the mean of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item var.pred numeric/matrix: the variance of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icl.pred numeric/matrix: the percentile of 100*((1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item icu.pred numeric/matrix: the percentile of 100*(1-(1-pred.cred)/2)% of the predictive distribution of a next observation. Same type and shape as the parameter in model.
   \item log.like numeric: the The log likelihood for the outcome given the conjugated parameters.
}
}
\description{
Calculate the values for the predictive distribution given the values of the parameter of the conjugated distribution of the linear predictor.
The data is assumed to have Poisson distribution with its mean having distribution Gamma with shape parameter a e rate parameter b.
In this scenario, the marginal distribution of the data is Negative Binomial with a as the dispersion parameter and b/(b+1) as the probability.
}
\seealso{
Other auxiliary functions for a Poisson outcome: 
\code{\link{convert_Normal_Poisson}()},
\code{\link{convert_Poisson_Normal}()},
\code{\link{update_Poisson}()}
}
\concept{auxiliary functions for a Poisson outcome}
\keyword{internal}
