% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_helper.R
\name{noise_block}
\alias{noise_block}
\alias{noise}
\title{noise_block}
\usage{
noise_block(..., name = "Noise", D = 0.99, R1 = 0.1, H = 0)

noise(name = "Noise", D = 0.99, R1 = 0.1, H = 0, X = 1)
}
\arguments{
\item{...}{Named values for the planning matrix.}

\item{name}{String: An optional argument providing the name for this block. Can be useful to identify the models with meaningful labels, also, the name used will be used in some auxiliary functions.}

\item{D}{scalar or vector: A sequence of values specifying the desired discount factor for each time. It should have length 1 or t, where t is the size of the series. If both D and H are specified, the value of D is ignored.}

\item{R1}{scalar: The prior variance of the noise.}

\item{H}{scalar: The variance of the noise. If both D and H are specified, the value of D is ignored.}

\item{X}{Vector or scalar: An argument providing the values of the covariate X_t.}
}
\value{
A dlm_block object containing the following values:
\itemize{
   \item FF Array: A 3D-array containing the regression matrix for each time. Its dimension should be n x k x t, where n is the number of latent states, k is the number of linear predictors in the model and t is the time series length.
   \item FF.labs Matrix: A n x k character matrix describing the type of value of each element of FF.
   \item G Matrix: A 3D-array containing the evolution matrix for each time. Its dimension should be n x n x t, where n is the number of latent states and t is the time series length.
   \item G.labs Matrix: A n x n character matrix describing the type of value of each element of G.
   \item D Array: A 3D-array containing the discount factor matrix for each time. Its dimension should be n x n x t, where n is the number of latent states and t is the time series length.
   \item H Array: A 3D-array containing the covariance matrix of the noise for each time. Its dimension should be the same as D.
   \item a1 Vector: The prior mean for the latent vector.
   \item R1 Matrix: The prior covariance matrix for the latent vector.
   \item var.names list: A list containing the variables indexes by their name.
   \item order Positive integer: Same as argument.
   \item n Positive integer: The number of latent states associated with this block (2).
   \item t Positive integer: The number of time steps associated with this block. If 1, the block is compatible with blocks of any time length, but if t is greater than 1, this block can only be used with blocks of the same time length.
   \item k Positive integer: The number of outcomes associated with this block. This block can only be used with blocks with the same outcome length.
   \item pred.names Vector: The name of the linear predictors associated with this block.
   \item monitoring Vector: The combination of monitoring, monitoring and monitoring.pulse.
   \item type Character: The type of block (Noise).
}
}
\description{
Creates the structure for a Noise block. This block represents an independent random noise that should be added to the linear predictor.
The variance of the noise cannot be formally estimated, as such we use a discount strategy similar to that of \insertCite{WestHarr-DLM;textual}{kDGLM} to specify it.
}
\details{
For the details about the implementation see \insertCite{ArtigoPacote;textual}{kDGLM}.

For the details about dynamic regression models in the context of DLMs, see \insertCite{WestHarr-DLM;textual}{kDGLM}, chapters 6 and 9.
}
\examples{

noise_block(mu = 1, D = 0.99, R1 = 1e-2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fit_model}}

Other auxiliary functions for structural blocks: 
\code{\link{TF_block}()},
\code{\link{block_mult}()},
\code{\link{block_rename}()},
\code{\link{block_superpos}()},
\code{\link{ffs_block}()},
\code{\link{harmonic_block}()},
\code{\link{intervention}()},
\code{\link{polynomial_block}()},
\code{\link{regression_block}()},
\code{\link{specify.dlm_block}()},
\code{\link{summary.dlm_block}()}
}
\concept{auxiliary functions for structural blocks}
